/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.studio.v1.flow.engagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Step extends Resource {
    private static final long serialVersionUID = 221317830784095L;

    /**
     * Create a StepReader to execute read.
     *
     * @param pathFlowSid The SID of the Flow
     * @param pathEngagementSid The SID of the Engagement
     * @return StepReader capable of executing the read
     */
    public static StepReader reader(final String pathFlowSid,
                                    final String pathEngagementSid) {
        return new StepReader(pathFlowSid, pathEngagementSid);
    }

    /**
     * Create a StepFetcher to execute fetch.
     *
     * @param pathFlowSid The SID of the Flow
     * @param pathEngagementSid The SID of the Engagement
     * @param pathSid The SID that identifies the resource to fetch
     * @return StepFetcher capable of executing the fetch
     */
    public static StepFetcher fetcher(final String pathFlowSid,
                                      final String pathEngagementSid,
                                      final String pathSid) {
        return new StepFetcher(pathFlowSid, pathEngagementSid, pathSid);
    }

    /**
     * Converts a JSON String into a Step object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Step object represented by the provided JSON
     */
    public static Step fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Step.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Step object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Step object represented by the provided JSON
     */
    public static Step fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Step.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String engagementSid;
    private final String name;
    private final Map<String, Object> context;
    private final String transitionedFrom;
    private final String transitionedTo;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Step(@JsonProperty("sid")
                 final String sid,
                 @JsonProperty("account_sid")
                 final String accountSid,
                 @JsonProperty("flow_sid")
                 final String flowSid,
                 @JsonProperty("engagement_sid")
                 final String engagementSid,
                 @JsonProperty("name")
                 final String name,
                 @JsonProperty("context")
                 final Map<String, Object> context,
                 @JsonProperty("transitioned_from")
                 final String transitionedFrom,
                 @JsonProperty("transitioned_to")
                 final String transitionedTo,
                 @JsonProperty("date_created")
                 final String dateCreated,
                 @JsonProperty("date_updated")
                 final String dateUpdated,
                 @JsonProperty("url")
                 final URI url,
                 @JsonProperty("links")
                 final Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.engagementSid = engagementSid;
        this.name = name;
        this.context = context;
        this.transitionedFrom = transitionedFrom;
        this.transitionedTo = transitionedTo;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Flow.
     *
     * @return The SID of the Flow
     */
    public final String getFlowSid() {
        return this.flowSid;
    }

    /**
     * Returns The SID of the Engagement.
     *
     * @return The SID of the Engagement
     */
    public final String getEngagementSid() {
        return this.engagementSid;
    }

    /**
     * Returns The event that caused the Flow to transition to the Step.
     *
     * @return The event that caused the Flow to transition to the Step
     */
    public final String getName() {
        return this.name;
    }

    /**
     * Returns The current state of the flow.
     *
     * @return The current state of the flow
     */
    public final Map<String, Object> getContext() {
        return this.context;
    }

    /**
     * Returns The Widget that preceded the Widget for the Step.
     *
     * @return The Widget that preceded the Widget for the Step
     */
    public final String getTransitionedFrom() {
        return this.transitionedFrom;
    }

    /**
     * Returns The Widget that will follow the Widget for the Step.
     *
     * @return The Widget that will follow the Widget for the Step
     */
    public final String getTransitionedTo() {
        return this.transitionedTo;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The URLs of related resources.
     *
     * @return The URLs of related resources
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Step other = (Step) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(flowSid, other.flowSid) &&
               Objects.equals(engagementSid, other.engagementSid) &&
               Objects.equals(name, other.name) &&
               Objects.equals(context, other.context) &&
               Objects.equals(transitionedFrom, other.transitionedFrom) &&
               Objects.equals(transitionedTo, other.transitionedTo) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            flowSid,
                            engagementSid,
                            name,
                            context,
                            transitionedFrom,
                            transitionedTo,
                            dateCreated,
                            dateUpdated,
                            url,
                            links);
    }
}