/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.studio.v1.flow.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ExecutionStep extends Resource {
    private static final long serialVersionUID = 111880953972806L;

    /**
     * Create a ExecutionStepReader to execute read.
     *
     * @param pathFlowSid The SID of the Flow
     * @param pathExecutionSid The SID of the Execution
     * @return ExecutionStepReader capable of executing the read
     */
    public static ExecutionStepReader reader(final String pathFlowSid,
                                             final String pathExecutionSid) {
        return new ExecutionStepReader(pathFlowSid, pathExecutionSid);
    }

    /**
     * Create a ExecutionStepFetcher to execute fetch.
     *
     * @param pathFlowSid The SID of the Flow
     * @param pathExecutionSid The SID of the Execution
     * @param pathSid The unique string that identifies the resource
     * @return ExecutionStepFetcher capable of executing the fetch
     */
    public static ExecutionStepFetcher fetcher(final String pathFlowSid,
                                               final String pathExecutionSid,
                                               final String pathSid) {
        return new ExecutionStepFetcher(pathFlowSid, pathExecutionSid, pathSid);
    }

    /**
     * Converts a JSON String into a ExecutionStep object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ExecutionStep object represented by the provided JSON
     */
    public static ExecutionStep fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ExecutionStep.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ExecutionStep object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ExecutionStep object represented by the provided JSON
     */
    public static ExecutionStep fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ExecutionStep.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String executionSid;
    private final String name;
    private final Map<String, Object> context;
    private final String transitionedFrom;
    private final String transitionedTo;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private ExecutionStep(@JsonProperty("sid")
                          final String sid,
                          @JsonProperty("account_sid")
                          final String accountSid,
                          @JsonProperty("flow_sid")
                          final String flowSid,
                          @JsonProperty("execution_sid")
                          final String executionSid,
                          @JsonProperty("name")
                          final String name,
                          @JsonProperty("context")
                          final Map<String, Object> context,
                          @JsonProperty("transitioned_from")
                          final String transitionedFrom,
                          @JsonProperty("transitioned_to")
                          final String transitionedTo,
                          @JsonProperty("date_created")
                          final String dateCreated,
                          @JsonProperty("date_updated")
                          final String dateUpdated,
                          @JsonProperty("url")
                          final URI url,
                          @JsonProperty("links")
                          final Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.executionSid = executionSid;
        this.name = name;
        this.context = context;
        this.transitionedFrom = transitionedFrom;
        this.transitionedTo = transitionedTo;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Flow.
     *
     * @return The SID of the Flow
     */
    public final String getFlowSid() {
        return this.flowSid;
    }

    /**
     * Returns The SID of the Execution.
     *
     * @return The SID of the Execution
     */
    public final String getExecutionSid() {
        return this.executionSid;
    }

    /**
     * Returns The event that caused the Flow to transition to the Step.
     *
     * @return The event that caused the Flow to transition to the Step
     */
    public final String getName() {
        return this.name;
    }

    /**
     * Returns The current state of the flow.
     *
     * @return The current state of the flow
     */
    public final Map<String, Object> getContext() {
        return this.context;
    }

    /**
     * Returns The Widget that preceded the Widget for the Step.
     *
     * @return The Widget that preceded the Widget for the Step
     */
    public final String getTransitionedFrom() {
        return this.transitionedFrom;
    }

    /**
     * Returns The Widget that will follow the Widget for the Step.
     *
     * @return The Widget that will follow the Widget for the Step
     */
    public final String getTransitionedTo() {
        return this.transitionedTo;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The URLs of related resources.
     *
     * @return The URLs of related resources
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ExecutionStep other = (ExecutionStep) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(flowSid, other.flowSid) &&
               Objects.equals(executionSid, other.executionSid) &&
               Objects.equals(name, other.name) &&
               Objects.equals(context, other.context) &&
               Objects.equals(transitionedFrom, other.transitionedFrom) &&
               Objects.equals(transitionedTo, other.transitionedTo) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            flowSid,
                            executionSid,
                            name,
                            context,
                            transitionedFrom,
                            transitionedTo,
                            dateCreated,
                            dateUpdated,
                            url,
                            links);
    }
}