/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.studio.v2.flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class FlowRevision extends Resource {
    private static final long serialVersionUID = 118153433744018L;

    public enum Status {
        DRAFT("draft"),
        PUBLISHED("published");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    /**
     * Create a FlowRevisionReader to execute read.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return FlowRevisionReader capable of executing the read
     */
    public static FlowRevisionReader reader(final String pathSid) {
        return new FlowRevisionReader(pathSid);
    }

    /**
     * Create a FlowRevisionFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @param pathRevision Specific Revision number or can be `LatestPublished` and
     *                     `LatestRevision`
     * @return FlowRevisionFetcher capable of executing the fetch
     */
    public static FlowRevisionFetcher fetcher(final String pathSid,
                                              final String pathRevision) {
        return new FlowRevisionFetcher(pathSid, pathRevision);
    }

    /**
     * Converts a JSON String into a FlowRevision object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return FlowRevision object represented by the provided JSON
     */
    public static FlowRevision fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, FlowRevision.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a FlowRevision object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return FlowRevision object represented by the provided JSON
     */
    public static FlowRevision fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, FlowRevision.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final Map<String, Object> definition;
    private final FlowRevision.Status status;
    private final Integer revision;
    private final String commitMessage;
    private final Boolean valid;
    private final List<Map<String, Object>> errors;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private FlowRevision(@JsonProperty("sid")
                         final String sid,
                         @JsonProperty("account_sid")
                         final String accountSid,
                         @JsonProperty("friendly_name")
                         final String friendlyName,
                         @JsonProperty("definition")
                         final Map<String, Object> definition,
                         @JsonProperty("status")
                         final FlowRevision.Status status,
                         @JsonProperty("revision")
                         final Integer revision,
                         @JsonProperty("commit_message")
                         final String commitMessage,
                         @JsonProperty("valid")
                         final Boolean valid,
                         @JsonProperty("errors")
                         final List<Map<String, Object>> errors,
                         @JsonProperty("date_created")
                         final String dateCreated,
                         @JsonProperty("date_updated")
                         final String dateUpdated,
                         @JsonProperty("url")
                         final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.definition = definition;
        this.status = status;
        this.revision = revision;
        this.commitMessage = commitMessage;
        this.valid = valid;
        this.errors = errors;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The string that you assigned to describe the Flow.
     *
     * @return The string that you assigned to describe the Flow
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns JSON representation of flow definition.
     *
     * @return JSON representation of flow definition
     */
    public final Map<String, Object> getDefinition() {
        return this.definition;
    }

    /**
     * Returns The status of the Flow.
     *
     * @return The status of the Flow
     */
    public final FlowRevision.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The latest revision number of the Flow's definition.
     *
     * @return The latest revision number of the Flow's definition
     */
    public final Integer getRevision() {
        return this.revision;
    }

    /**
     * Returns Description of change made in the revision.
     *
     * @return Description of change made in the revision
     */
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    /**
     * Returns Boolean if the flow definition is valid.
     *
     * @return Boolean if the flow definition is valid
     */
    public final Boolean getValid() {
        return this.valid;
    }

    /**
     * Returns List of error in the flow definition.
     *
     * @return List of error in the flow definition
     */
    public final List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FlowRevision other = (FlowRevision) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(definition, other.definition) &&
               Objects.equals(status, other.status) &&
               Objects.equals(revision, other.revision) &&
               Objects.equals(commitMessage, other.commitMessage) &&
               Objects.equals(valid, other.valid) &&
               Objects.equals(errors, other.errors) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            friendlyName,
                            definition,
                            status,
                            revision,
                            commitMessage,
                            valid,
                            errors,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}