/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class FlowRevisionFetcher extends Fetcher<FlowRevision> {
    private final String pathSid;
    private final String pathRevision;

    /**
     * Construct a new FlowRevisionFetcher.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @param pathRevision Specific Revision number or can be `LatestPublished` and
     *                     `LatestRevision`
     */
    public FlowRevisionFetcher(final String pathSid,
                               final String pathRevision) {
        this.pathSid = pathSid;
        this.pathRevision = pathRevision;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched FlowRevision
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public FlowRevision fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.STUDIO.toString(),
            "/v2/Flows/" + this.pathSid + "/Revisions/" + this.pathRevision + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("FlowRevision fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return FlowRevision.fromJson(response.getStream(), client.getObjectMapper());
    }
}