/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class FlowTestUserFetcher extends Fetcher<FlowTestUser> {
    private final String pathSid;

    /**
     * Construct a new FlowTestUserFetcher.
     *
     * @param pathSid Unique identifier of the flow.
     */
    public FlowTestUserFetcher(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched FlowTestUser
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public FlowTestUser fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.STUDIO.toString(),
            "/v2/Flows/" + this.pathSid + "/TestUsers"
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("FlowTestUser fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return FlowTestUser.fromJson(response.getStream(), client.getObjectMapper());
    }
}