/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class FleetCreator extends Creator<Fleet> {
    private final String networkAccessProfile;
    private String uniqueName;
    private Boolean dataEnabled;
    private Integer dataLimit;
    private URI ipCommandsUrl;
    private HttpMethod ipCommandsMethod;
    private Boolean smsCommandsEnabled;
    private URI smsCommandsUrl;
    private HttpMethod smsCommandsMethod;

    /**
     * Construct a new FleetCreator.
     *
     * @param networkAccessProfile The SID or unique name of the Network Access
     *                             Profile of the Fleet
     */
    public FleetCreator(final String networkAccessProfile) {
        this.networkAccessProfile = networkAccessProfile;
    }

    /**
     * An application-defined string that uniquely identifies the resource. It can
     * be used in place of the resource's `sid` in the URL to address the resource..
     *
     * @param uniqueName An application-defined string that uniquely identifies the
     *                   resource
     * @return this
     */
    public FleetCreator setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    /**
     * Defines whether SIMs in the Fleet are capable of using 2G/3G/4G/LTE/CAT-M
     * data connectivity. Defaults to `true`..
     *
     * @param dataEnabled Defines whether SIMs in the Fleet are capable of using
     *                    data connectivity
     * @return this
     */
    public FleetCreator setDataEnabled(final Boolean dataEnabled) {
        this.dataEnabled = dataEnabled;
        return this;
    }

    /**
     * The total data usage (download and upload combined) in Megabytes that each
     * Sim resource assigned to the Fleet resource can consume during a billing
     * period (normally one month). Value must be between 1MB (1) and 2TB
     * (2,000,000). Defaults to 1GB (1,000)..
     *
     * @param dataLimit The total data usage (download and upload combined) in
     *                  Megabytes that each Sim resource assigned to the Fleet
     *                  resource can consume
     * @return this
     */
    public FleetCreator setDataLimit(final Integer dataLimit) {
        this.dataLimit = dataLimit;
        return this;
    }

    /**
     * The URL that will receive a webhook when a Super SIM in the Fleet is used to
     * send an IP Command from your device to a special IP address. Your server
     * should respond with an HTTP status code in the 200 range; any response body
     * will be ignored..
     *
     * @param ipCommandsUrl The URL that will receive a webhook when a Super SIM in
     *                      the Fleet is used to send an IP Command from your device
     * @return this
     */
    public FleetCreator setIpCommandsUrl(final URI ipCommandsUrl) {
        this.ipCommandsUrl = ipCommandsUrl;
        return this;
    }

    /**
     * The URL that will receive a webhook when a Super SIM in the Fleet is used to
     * send an IP Command from your device to a special IP address. Your server
     * should respond with an HTTP status code in the 200 range; any response body
     * will be ignored..
     *
     * @param ipCommandsUrl The URL that will receive a webhook when a Super SIM in
     *                      the Fleet is used to send an IP Command from your device
     * @return this
     */
    public FleetCreator setIpCommandsUrl(final String ipCommandsUrl) {
        return setIpCommandsUrl(Promoter.uriFromString(ipCommandsUrl));
    }

    /**
     * A string representing the HTTP method to use when making a request to
     * `ip_commands_url`. Can be one of `POST` or `GET`. Defaults to `POST`..
     *
     * @param ipCommandsMethod A string representing the HTTP method to use when
     *                         making a request to `ip_commands_url`
     * @return this
     */
    public FleetCreator setIpCommandsMethod(final HttpMethod ipCommandsMethod) {
        this.ipCommandsMethod = ipCommandsMethod;
        return this;
    }

    /**
     * Defines whether SIMs in the Fleet are capable of sending and receiving
     * machine-to-machine SMS via Commands. Defaults to `true`..
     *
     * @param smsCommandsEnabled Defines whether SIMs in the Fleet are capable of
     *                           sending and receiving machine-to-machine SMS via
     *                           Commands
     * @return this
     */
    public FleetCreator setSmsCommandsEnabled(final Boolean smsCommandsEnabled) {
        this.smsCommandsEnabled = smsCommandsEnabled;
        return this;
    }

    /**
     * The URL that will receive a webhook when a Super SIM in the Fleet is used to
     * send an SMS from your device to the SMS Commands number. Your server should
     * respond with an HTTP status code in the 200 range; any response body will be
     * ignored..
     *
     * @param smsCommandsUrl The URL that will receive a webhook when a Super SIM
     *                       in the Fleet is used to send an SMS from your device to
     *                       the SMS Commands number
     * @return this
     */
    public FleetCreator setSmsCommandsUrl(final URI smsCommandsUrl) {
        this.smsCommandsUrl = smsCommandsUrl;
        return this;
    }

    /**
     * The URL that will receive a webhook when a Super SIM in the Fleet is used to
     * send an SMS from your device to the SMS Commands number. Your server should
     * respond with an HTTP status code in the 200 range; any response body will be
     * ignored..
     *
     * @param smsCommandsUrl The URL that will receive a webhook when a Super SIM
     *                       in the Fleet is used to send an SMS from your device to
     *                       the SMS Commands number
     * @return this
     */
    public FleetCreator setSmsCommandsUrl(final String smsCommandsUrl) {
        return setSmsCommandsUrl(Promoter.uriFromString(smsCommandsUrl));
    }

    /**
     * A string representing the HTTP method to use when making a request to
     * `sms_commands_url`. Can be one of `POST` or `GET`. Defaults to `POST`..
     *
     * @param smsCommandsMethod A string representing the HTTP method to use when
     *                          making a request to `sms_commands_url`
     * @return this
     */
    public FleetCreator setSmsCommandsMethod(final HttpMethod smsCommandsMethod) {
        this.smsCommandsMethod = smsCommandsMethod;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Fleet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Fleet create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.SUPERSIM.toString(),
            "/v1/Fleets"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Fleet creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Fleet.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (networkAccessProfile != null) {
            request.addPostParam("NetworkAccessProfile", networkAccessProfile.toString());
        }

        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (dataEnabled != null) {
            request.addPostParam("DataEnabled", dataEnabled.toString());
        }

        if (dataLimit != null) {
            request.addPostParam("DataLimit", dataLimit.toString());
        }

        if (ipCommandsUrl != null) {
            request.addPostParam("IpCommandsUrl", ipCommandsUrl.toString());
        }

        if (ipCommandsMethod != null) {
            request.addPostParam("IpCommandsMethod", ipCommandsMethod.toString());
        }

        if (smsCommandsEnabled != null) {
            request.addPostParam("SmsCommandsEnabled", smsCommandsEnabled.toString());
        }

        if (smsCommandsUrl != null) {
            request.addPostParam("SmsCommandsUrl", smsCommandsUrl.toString());
        }

        if (smsCommandsMethod != null) {
            request.addPostParam("SmsCommandsMethod", smsCommandsMethod.toString());
        }
    }
}