/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class IpCommand extends Resource {
    private static final long serialVersionUID = 231772407740098L;

    public enum Status {
        QUEUED("queued"),
        SENT("sent"),
        RECEIVED("received"),
        FAILED("failed");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum Direction {
        TO_SIM("to_sim"),
        FROM_SIM("from_sim");

        private final String value;

        private Direction(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Direction from a string.
         * @param value string value
         * @return generated Direction
         */
        @JsonCreator
        public static Direction forValue(final String value) {
            return Promoter.enumFromString(value, Direction.values());
        }
    }

    public enum PayloadType {
        TEXT("text"),
        BINARY("binary");

        private final String value;

        private PayloadType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a PayloadType from a string.
         * @param value string value
         * @return generated PayloadType
         */
        @JsonCreator
        public static PayloadType forValue(final String value) {
            return Promoter.enumFromString(value, PayloadType.values());
        }
    }

    /**
     * Create a IpCommandCreator to execute create.
     *
     * @param sim The sid or unique_name of the Super SIM to send the IP Command to
     * @param payload The payload to be delivered to the device
     * @param devicePort The device port to which the IP Command will be sent
     * @return IpCommandCreator capable of executing the create
     */
    public static IpCommandCreator creator(final String sim,
                                           final String payload,
                                           final Integer devicePort) {
        return new IpCommandCreator(sim, payload, devicePort);
    }

    /**
     * Create a IpCommandFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return IpCommandFetcher capable of executing the fetch
     */
    public static IpCommandFetcher fetcher(final String pathSid) {
        return new IpCommandFetcher(pathSid);
    }

    /**
     * Create a IpCommandReader to execute read.
     *
     * @return IpCommandReader capable of executing the read
     */
    public static IpCommandReader reader() {
        return new IpCommandReader();
    }

    /**
     * Converts a JSON String into a IpCommand object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return IpCommand object represented by the provided JSON
     */
    public static IpCommand fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, IpCommand.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a IpCommand object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return IpCommand object represented by the provided JSON
     */
    public static IpCommand fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, IpCommand.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String simSid;
    private final String simIccid;
    private final IpCommand.Status status;
    private final IpCommand.Direction direction;
    private final String deviceIp;
    private final Integer devicePort;
    private final IpCommand.PayloadType payloadType;
    private final String payload;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private IpCommand(@JsonProperty("sid")
                      final String sid,
                      @JsonProperty("account_sid")
                      final String accountSid,
                      @JsonProperty("sim_sid")
                      final String simSid,
                      @JsonProperty("sim_iccid")
                      final String simIccid,
                      @JsonProperty("status")
                      final IpCommand.Status status,
                      @JsonProperty("direction")
                      final IpCommand.Direction direction,
                      @JsonProperty("device_ip")
                      final String deviceIp,
                      @JsonProperty("device_port")
                      final Integer devicePort,
                      @JsonProperty("payload_type")
                      final IpCommand.PayloadType payloadType,
                      @JsonProperty("payload")
                      final String payload,
                      @JsonProperty("date_created")
                      final String dateCreated,
                      @JsonProperty("date_updated")
                      final String dateUpdated,
                      @JsonProperty("url")
                      final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.simSid = simSid;
        this.simIccid = simIccid;
        this.status = status;
        this.direction = direction;
        this.deviceIp = deviceIp;
        this.devicePort = devicePort;
        this.payloadType = payloadType;
        this.payload = payload;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Super SIM that this IP Command was sent to or from.
     *
     * @return The SID of the Super SIM that this IP Command was sent to or from
     */
    public final String getSimSid() {
        return this.simSid;
    }

    /**
     * Returns The ICCID of the Super SIM that this IP Command was sent to or from.
     *
     * @return The ICCID of the Super SIM that this IP Command was sent to or from
     */
    public final String getSimIccid() {
        return this.simIccid;
    }

    /**
     * Returns The status of the IP Command.
     *
     * @return The status of the IP Command
     */
    public final IpCommand.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The direction of the IP Command.
     *
     * @return The direction of the IP Command
     */
    public final IpCommand.Direction getDirection() {
        return this.direction;
    }

    /**
     * Returns The IP address of the device that the IP Command was sent to or
     * received from.
     *
     * @return The IP address of the device that the IP Command was sent to or
     *         received from
     */
    public final String getDeviceIp() {
        return this.deviceIp;
    }

    /**
     * Returns The port that the IP Command either originated from or was sent to.
     *
     * @return The port that the IP Command either originated from or was sent to
     */
    public final Integer getDevicePort() {
        return this.devicePort;
    }

    /**
     * Returns The payload type of the IP Command.
     *
     * @return The payload type of the IP Command
     */
    public final IpCommand.PayloadType getPayloadType() {
        return this.payloadType;
    }

    /**
     * Returns The payload of the IP Command sent to or from the Super SIM.
     *
     * @return The payload of the IP Command sent to or from the Super SIM
     */
    public final String getPayload() {
        return this.payload;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the IP Command resource.
     *
     * @return The absolute URL of the IP Command resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        IpCommand other = (IpCommand) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(simSid, other.simSid) &&
               Objects.equals(simIccid, other.simIccid) &&
               Objects.equals(status, other.status) &&
               Objects.equals(direction, other.direction) &&
               Objects.equals(deviceIp, other.deviceIp) &&
               Objects.equals(devicePort, other.devicePort) &&
               Objects.equals(payloadType, other.payloadType) &&
               Objects.equals(payload, other.payload) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            simSid,
                            simIccid,
                            status,
                            direction,
                            deviceIp,
                            devicePort,
                            payloadType,
                            payload,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}