/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class NetworkReader extends Reader<Network> {
    private String isoCountry;
    private String mcc;
    private String mnc;

    /**
     * The <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO country
     * code</a> of the Network resources to read..
     *
     * @param isoCountry The ISO country code of the Network resources to read
     * @return this
     */
    public NetworkReader setIsoCountry(final String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    /**
     * The 'mobile country code' of a country. Network resources with this `mcc` in
     * their `identifiers` will be read..
     *
     * @param mcc The MCC of Network resource identifiers to be read
     * @return this
     */
    public NetworkReader setMcc(final String mcc) {
        this.mcc = mcc;
        return this;
    }

    /**
     * The 'mobile network code' of a mobile operator network. Network resources
     * with this `mnc` in their `identifiers` will be read..
     *
     * @param mnc The MNC of Network resource identifiers to be read
     * @return this
     */
    public NetworkReader setMnc(final String mnc) {
        this.mnc = mnc;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Network ResourceSet
     */
    @Override
    public ResourceSet<Network> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Network ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Network> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.SUPERSIM.toString(),
            "/v1/Networks"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return Network ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Network> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<Network> nextPage(final Page<Network> page,
                                  final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<Network> previousPage(final Page<Network> page,
                                      final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of Network Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<Network> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Network read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "networks",
            response.getContent(),
            Network.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (isoCountry != null) {
            request.addQueryParam("IsoCountry", isoCountry);
        }

        if (mcc != null) {
            request.addQueryParam("Mcc", mcc);
        }

        if (mnc != null) {
            request.addQueryParam("Mnc", mnc);
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}