/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SimReader extends Reader<Sim> {
    private Sim.Status status;
    private String fleet;
    private String iccid;

    /**
     * The status of the Sim resources to read. Can be `new`, `ready`, `active`,
     * `inactive`, or `scheduled`..
     *
     * @param status The status of the Sim resources to read
     * @return this
     */
    public SimReader setStatus(final Sim.Status status) {
        this.status = status;
        return this;
    }

    /**
     * The SID or unique name of the Fleet to which a list of Sims are assigned..
     *
     * @param fleet The SID or unique name of the Fleet to which a list of Sims are
     *              assigned
     * @return this
     */
    public SimReader setFleet(final String fleet) {
        this.fleet = fleet;
        return this;
    }

    /**
     * The <a
     * href="https://en.wikipedia.org/wiki/Subscriber_identity_module#ICCID">ICCID</a>
     * associated with a Super SIM to filter the list by. Passing this parameter
     * will always return a list containing zero or one SIMs..
     *
     * @param iccid The ICCID associated with a Super SIM to filter the list by
     * @return this
     */
    public SimReader setIccid(final String iccid) {
        this.iccid = iccid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Sim ResourceSet
     */
    @Override
    public ResourceSet<Sim> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Sim ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Sim> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.SUPERSIM.toString(),
            "/v1/Sims"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return Sim ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Sim> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<Sim> nextPage(final Page<Sim> page,
                              final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<Sim> previousPage(final Page<Sim> page,
                                  final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of Sim Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<Sim> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Sim read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "sims",
            response.getContent(),
            Sim.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (status != null) {
            request.addQueryParam("Status", status.toString());
        }

        if (fleet != null) {
            request.addQueryParam("Fleet", fleet.toString());
        }

        if (iccid != null) {
            request.addQueryParam("Iccid", iccid);
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}