/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SmsCommandCreator extends Creator<SmsCommand> {
    private final String sim;
    private final String payload;
    private HttpMethod callbackMethod;
    private URI callbackUrl;

    /**
     * Construct a new SmsCommandCreator.
     *
     * @param sim The sid or unique_name of the SIM to send the SMS Command to
     * @param payload The message body of the SMS Command
     */
    public SmsCommandCreator(final String sim,
                             final String payload) {
        this.sim = sim;
        this.payload = payload;
    }

    /**
     * The HTTP method we should use to call `callback_url`. Can be: `GET` or `POST`
     * and the default is POST..
     *
     * @param callbackMethod The HTTP method we should use to call callback_url
     * @return this
     */
    public SmsCommandCreator setCallbackMethod(final HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    /**
     * The URL we should call using the `callback_method` after we have sent the
     * command..
     *
     * @param callbackUrl The URL we should call after we have sent the command
     * @return this
     */
    public SmsCommandCreator setCallbackUrl(final URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    /**
     * The URL we should call using the `callback_method` after we have sent the
     * command..
     *
     * @param callbackUrl The URL we should call after we have sent the command
     * @return this
     */
    public SmsCommandCreator setCallbackUrl(final String callbackUrl) {
        return setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created SmsCommand
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public SmsCommand create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.SUPERSIM.toString(),
            "/v1/SmsCommands"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("SmsCommand creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return SmsCommand.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (sim != null) {
            request.addPostParam("Sim", sim);
        }

        if (payload != null) {
            request.addPostParam("Payload", payload);
        }

        if (callbackMethod != null) {
            request.addPostParam("CallbackMethod", callbackMethod.toString());
        }

        if (callbackUrl != null) {
            request.addPostParam("CallbackUrl", callbackUrl.toString());
        }
    }
}