/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SmsCommandReader extends Reader<SmsCommand> {
    private String sim;
    private SmsCommand.Status status;
    private SmsCommand.Direction direction;

    /**
     * The SID or unique name of the Sim resource that SMS Command was sent to or
     * from..
     *
     * @param sim The SID or unique name of the Sim resource that SMS Command was
     *            sent to or from.
     * @return this
     */
    public SmsCommandReader setSim(final String sim) {
        this.sim = sim;
        return this;
    }

    /**
     * The status of the SMS Command. Can be: `queued`, `sent`, `delivered`,
     * `received` or `failed`. See the <a
     * href="https://www.twilio.com/docs/wireless/api/smscommand-resource#status-values">SMS
     * Command Status Values</a> for a description of each..
     *
     * @param status The status of the SMS Command
     * @return this
     */
    public SmsCommandReader setStatus(final SmsCommand.Status status) {
        this.status = status;
        return this;
    }

    /**
     * The direction of the SMS Command. Can be `to_sim` or `from_sim`. The value of
     * `to_sim` is synonymous with the term `mobile terminated`, and `from_sim` is
     * synonymous with the term `mobile originated`..
     *
     * @param direction The direction of the SMS Command
     * @return this
     */
    public SmsCommandReader setDirection(final SmsCommand.Direction direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return SmsCommand ResourceSet
     */
    @Override
    public ResourceSet<SmsCommand> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return SmsCommand ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<SmsCommand> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.SUPERSIM.toString(),
            "/v1/SmsCommands"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return SmsCommand ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<SmsCommand> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<SmsCommand> nextPage(final Page<SmsCommand> page,
                                     final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<SmsCommand> previousPage(final Page<SmsCommand> page,
                                         final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of SmsCommand Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<SmsCommand> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("SmsCommand read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "sms_commands",
            response.getContent(),
            SmsCommand.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (sim != null) {
            request.addQueryParam("Sim", sim.toString());
        }

        if (status != null) {
            request.addQueryParam("Status", status.toString());
        }

        if (direction != null) {
            request.addQueryParam("Direction", direction.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}