/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.sync.v1.service.syncmap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class SyncMapPermission extends Resource {
    private static final long serialVersionUID = 261843483205862L;

    /**
     * Create a SyncMapPermissionFetcher to execute fetch.
     *
     * @param pathServiceSid The SID of the Sync Service with the Sync Map
     *                       Permission resource to fetch
     * @param pathMapSid The SID of the Sync Map with the Sync Map Permission
     *                   resource to fetch
     * @param pathIdentity The application-defined string that uniquely identifies
     *                     the User's Sync Map Permission resource to fetch
     * @return SyncMapPermissionFetcher capable of executing the fetch
     */
    public static SyncMapPermissionFetcher fetcher(final String pathServiceSid,
                                                   final String pathMapSid,
                                                   final String pathIdentity) {
        return new SyncMapPermissionFetcher(pathServiceSid, pathMapSid, pathIdentity);
    }

    /**
     * Create a SyncMapPermissionDeleter to execute delete.
     *
     * @param pathServiceSid The SID of the Sync Service with the Sync Map
     *                       Permission resource to delete
     * @param pathMapSid The SID of the Sync Map with the Sync Map Permission
     *                   resource to delete
     * @param pathIdentity The application-defined string that uniquely identifies
     *                     the User's Sync Map Permission resource to delete
     * @return SyncMapPermissionDeleter capable of executing the delete
     */
    public static SyncMapPermissionDeleter deleter(final String pathServiceSid,
                                                   final String pathMapSid,
                                                   final String pathIdentity) {
        return new SyncMapPermissionDeleter(pathServiceSid, pathMapSid, pathIdentity);
    }

    /**
     * Create a SyncMapPermissionReader to execute read.
     *
     * @param pathServiceSid The SID of the Sync Service with the Sync Map
     *                       Permission resources to read
     * @param pathMapSid The SID of the Sync Map with the Permission resources to
     *                   read
     * @return SyncMapPermissionReader capable of executing the read
     */
    public static SyncMapPermissionReader reader(final String pathServiceSid,
                                                 final String pathMapSid) {
        return new SyncMapPermissionReader(pathServiceSid, pathMapSid);
    }

    /**
     * Create a SyncMapPermissionUpdater to execute update.
     *
     * @param pathServiceSid The SID of the Sync Service with the Sync Map
     *                       Permission resource to update
     * @param pathMapSid The SID of the Sync Map with the Sync Map Permission
     *                   resource to update
     * @param pathIdentity The application-defined string that uniquely identifies
     *                     the User's Sync Map Permission resource to update
     * @param read Read access
     * @param write Write access
     * @param manage Manage access
     * @return SyncMapPermissionUpdater capable of executing the update
     */
    public static SyncMapPermissionUpdater updater(final String pathServiceSid,
                                                   final String pathMapSid,
                                                   final String pathIdentity,
                                                   final Boolean read,
                                                   final Boolean write,
                                                   final Boolean manage) {
        return new SyncMapPermissionUpdater(pathServiceSid, pathMapSid, pathIdentity, read, write, manage);
    }

    /**
     * Converts a JSON String into a SyncMapPermission object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return SyncMapPermission object represented by the provided JSON
     */
    public static SyncMapPermission fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, SyncMapPermission.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a SyncMapPermission object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return SyncMapPermission object represented by the provided JSON
     */
    public static SyncMapPermission fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, SyncMapPermission.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String serviceSid;
    private final String mapSid;
    private final String identity;
    private final Boolean read;
    private final Boolean write;
    private final Boolean manage;
    private final URI url;

    @JsonCreator
    private SyncMapPermission(@JsonProperty("account_sid")
                              final String accountSid,
                              @JsonProperty("service_sid")
                              final String serviceSid,
                              @JsonProperty("map_sid")
                              final String mapSid,
                              @JsonProperty("identity")
                              final String identity,
                              @JsonProperty("read")
                              final Boolean read,
                              @JsonProperty("write")
                              final Boolean write,
                              @JsonProperty("manage")
                              final Boolean manage,
                              @JsonProperty("url")
                              final URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.mapSid = mapSid;
        this.identity = identity;
        this.read = read;
        this.write = write;
        this.manage = manage;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Sync Service that the resource is associated with.
     *
     * @return The SID of the Sync Service that the resource is associated with
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns Sync Map SID.
     *
     * @return Sync Map SID
     */
    public final String getMapSid() {
        return this.mapSid;
    }

    /**
     * Returns The identity of the user to whom the Sync Document Permission
     * applies.
     *
     * @return The identity of the user to whom the Sync Document Permission applies
     */
    public final String getIdentity() {
        return this.identity;
    }

    /**
     * Returns Read access.
     *
     * @return Read access
     */
    public final Boolean getRead() {
        return this.read;
    }

    /**
     * Returns Write access.
     *
     * @return Write access
     */
    public final Boolean getWrite() {
        return this.write;
    }

    /**
     * Returns Manage access.
     *
     * @return Manage access
     */
    public final Boolean getManage() {
        return this.manage;
    }

    /**
     * Returns The absolute URL of the Sync Map Permission resource.
     *
     * @return The absolute URL of the Sync Map Permission resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SyncMapPermission other = (SyncMapPermission) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(serviceSid, other.serviceSid) &&
               Objects.equals(mapSid, other.mapSid) &&
               Objects.equals(identity, other.identity) &&
               Objects.equals(read, other.read) &&
               Objects.equals(write, other.write) &&
               Objects.equals(manage, other.manage) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            serviceSid,
                            mapSid,
                            identity,
                            read,
                            write,
                            manage,
                            url);
    }
}