/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class TaskDeleter extends Deleter<Task> {
    private final String pathWorkspaceSid;
    private final String pathSid;
    private String ifMatch;

    /**
     * Construct a new TaskDeleter.
     *
     * @param pathWorkspaceSid The SID of the Workspace with the Task to delete
     * @param pathSid The SID of the resource to delete
     */
    public TaskDeleter(final String pathWorkspaceSid,
                       final String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathSid = pathSid;
    }

    /**
     * If provided, deletes this Task if (and only if) the <a
     * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/ETag">ETag</a>
     * header of the Task matches the provided value. This matches the semantics of
     * (and is implemented with) the HTTP <a
     * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-Match">If-Match
     * header</a>..
     *
     * @param ifMatch The If-Match HTTP request header
     * @return this
     */
    public TaskDeleter setIfMatch(final String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the delete.
     *
     * @param client TwilioRestClient with which to make the request
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public boolean delete(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.DELETE,
            Domains.TASKROUTER.toString(),
            "/v1/Workspaces/" + this.pathWorkspaceSid + "/Tasks/" + this.pathSid + ""
        );

        addHeaderParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Task delete failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return response.getStatusCode() == 204;
    }

    /**
     * Add the requested header parameters to the Request.
     *
     * @param request Request to add header params to
     */
    private void addHeaderParams(final Request request) {
        if (ifMatch != null) {
            request.addHeaderParam("If-Match", ifMatch);
        }
    }
}