/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class OriginationUrlUpdater extends Updater<OriginationUrl> {
    private final String pathTrunkSid;
    private final String pathSid;
    private Integer weight;
    private Integer priority;
    private Boolean enabled;
    private String friendlyName;
    private URI sipUrl;

    /**
     * Construct a new OriginationUrlUpdater.
     *
     * @param pathTrunkSid The SID of the Trunk from which to update the
     *                     OriginationUrl
     * @param pathSid The unique string that identifies the resource
     */
    public OriginationUrlUpdater(final String pathTrunkSid,
                                 final String pathSid) {
        this.pathTrunkSid = pathTrunkSid;
        this.pathSid = pathSid;
    }

    /**
     * The value that determines the relative share of the load the URI should
     * receive compared to other URIs with the same priority. Can be an integer from
     * 1 to 65535, inclusive, and the default is 10. URLs with higher values receive
     * more load than those with lower ones with the same priority..
     *
     * @param weight The value that determines the relative load the URI should
     *               receive compared to others with the same priority
     * @return this
     */
    public OriginationUrlUpdater setWeight(final Integer weight) {
        this.weight = weight;
        return this;
    }

    /**
     * The relative importance of the URI. Can be an integer from 0 to 65535,
     * inclusive, and the default is 10. The lowest number represents the most
     * important URI..
     *
     * @param priority The relative importance of the URI
     * @return this
     */
    public OriginationUrlUpdater setPriority(final Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Whether the URL is enabled. The default is `true`..
     *
     * @param enabled Whether the URL is enabled
     * @return this
     */
    public OriginationUrlUpdater setEnabled(final Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * A descriptive string that you create to describe the resource. It can be up
     * to 64 characters long..
     *
     * @param friendlyName A string to describe the resource
     * @return this
     */
    public OriginationUrlUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The SIP address you want Twilio to route your Origination calls to. This must
     * be a `sip:` schema. `sips` is NOT supported..
     *
     * @param sipUrl The SIP address you want Twilio to route your Origination
     *               calls to
     * @return this
     */
    public OriginationUrlUpdater setSipUrl(final URI sipUrl) {
        this.sipUrl = sipUrl;
        return this;
    }

    /**
     * The SIP address you want Twilio to route your Origination calls to. This must
     * be a `sip:` schema. `sips` is NOT supported..
     *
     * @param sipUrl The SIP address you want Twilio to route your Origination
     *               calls to
     * @return this
     */
    public OriginationUrlUpdater setSipUrl(final String sipUrl) {
        return setSipUrl(Promoter.uriFromString(sipUrl));
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated OriginationUrl
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public OriginationUrl update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUNKING.toString(),
            "/v1/Trunks/" + this.pathTrunkSid + "/OriginationUrls/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("OriginationUrl update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return OriginationUrl.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (weight != null) {
            request.addPostParam("Weight", weight.toString());
        }

        if (priority != null) {
            request.addPostParam("Priority", priority.toString());
        }

        if (enabled != null) {
            request.addPostParam("Enabled", enabled.toString());
        }

        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (sipUrl != null) {
            request.addPostParam("SipUrl", sipUrl.toString());
        }
    }
}