/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class RecordingUpdater extends Updater<Recording> {
    private final String pathTrunkSid;
    private Recording.RecordingMode mode;
    private Recording.RecordingTrim trim;

    /**
     * Construct a new RecordingUpdater.
     *
     * @param pathTrunkSid The SID of the Trunk.
     */
    public RecordingUpdater(final String pathTrunkSid) {
        this.pathTrunkSid = pathTrunkSid;
    }

    /**
     * The recording mode for the trunk. Can be do-not-record (default),
     * record-from-ringing, record-from-answer, record-from-ringing-dual, or
     * record-from-answer-dual..
     *
     * @param mode The recording mode for the trunk.
     * @return this
     */
    public RecordingUpdater setMode(final Recording.RecordingMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * The recording trim setting for the trunk. Can be do-not-trim (default) or
     * trim-silence..
     *
     * @param trim The recording trim setting for the trunk.
     * @return this
     */
    public RecordingUpdater setTrim(final Recording.RecordingTrim trim) {
        this.trim = trim;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Recording
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Recording update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUNKING.toString(),
            "/v1/Trunks/" + this.pathTrunkSid + "/Recording"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Recording update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (mode != null) {
            request.addPostParam("Mode", mode.toString());
        }

        if (trim != null) {
            request.addPostParam("Trim", trim.toString());
        }
    }
}