/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class CustomerProfilesChannelEndpointAssignmentCreator extends Creator<CustomerProfilesChannelEndpointAssignment> {
    private final String pathCustomerProfileSid;
    private final String channelEndpointType;
    private final String channelEndpointSid;

    /**
     * Construct a new CustomerProfilesChannelEndpointAssignmentCreator.
     *
     * @param pathCustomerProfileSid The unique string that identifies the resource.
     * @param channelEndpointType The type of channel endpoint
     * @param channelEndpointSid The sid of an channel endpoint
     */
    public CustomerProfilesChannelEndpointAssignmentCreator(final String pathCustomerProfileSid,
                                                            final String channelEndpointType,
                                                            final String channelEndpointSid) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created CustomerProfilesChannelEndpointAssignment
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public CustomerProfilesChannelEndpointAssignment create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUSTHUB.toString(),
            "/v1/CustomerProfiles/" + this.pathCustomerProfileSid + "/ChannelEndpointAssignments"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("CustomerProfilesChannelEndpointAssignment creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return CustomerProfilesChannelEndpointAssignment.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (channelEndpointType != null) {
            request.addPostParam("ChannelEndpointType", channelEndpointType);
        }

        if (channelEndpointSid != null) {
            request.addPostParam("ChannelEndpointSid", channelEndpointSid);
        }
    }
}