/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class CustomerProfilesEntityAssignmentsFetcher extends Fetcher<CustomerProfilesEntityAssignments> {
    private final String pathCustomerProfileSid;
    private final String pathSid;

    /**
     * Construct a new CustomerProfilesEntityAssignmentsFetcher.
     *
     * @param pathCustomerProfileSid The unique string that identifies the resource.
     * @param pathSid The unique string that identifies the resource
     */
    public CustomerProfilesEntityAssignmentsFetcher(final String pathCustomerProfileSid,
                                                    final String pathSid) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched CustomerProfilesEntityAssignments
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public CustomerProfilesEntityAssignments fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.TRUSTHUB.toString(),
            "/v1/CustomerProfiles/" + this.pathCustomerProfileSid + "/EntityAssignments/" + this.pathSid + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("CustomerProfilesEntityAssignments fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return CustomerProfilesEntityAssignments.fromJson(response.getStream(), client.getObjectMapper());
    }
}