/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class TrustProductsChannelEndpointAssignmentCreator extends Creator<TrustProductsChannelEndpointAssignment> {
    private final String pathTrustProductSid;
    private final String channelEndpointType;
    private final String channelEndpointSid;

    /**
     * Construct a new TrustProductsChannelEndpointAssignmentCreator.
     *
     * @param pathTrustProductSid The unique string that identifies the resource.
     * @param channelEndpointType The type of channel endpoint
     * @param channelEndpointSid The sid of an channel endpoint
     */
    public TrustProductsChannelEndpointAssignmentCreator(final String pathTrustProductSid,
                                                         final String channelEndpointType,
                                                         final String channelEndpointSid) {
        this.pathTrustProductSid = pathTrustProductSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created TrustProductsChannelEndpointAssignment
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public TrustProductsChannelEndpointAssignment create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUSTHUB.toString(),
            "/v1/TrustProducts/" + this.pathTrustProductSid + "/ChannelEndpointAssignments"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("TrustProductsChannelEndpointAssignment creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return TrustProductsChannelEndpointAssignment.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (channelEndpointType != null) {
            request.addPostParam("ChannelEndpointType", channelEndpointType);
        }

        if (channelEndpointSid != null) {
            request.addPostParam("ChannelEndpointSid", channelEndpointSid);
        }
    }
}