/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Template extends Resource {
    private static final long serialVersionUID = 55612496215958L;

    /**
     * Create a TemplateReader to execute read.
     *
     * @return TemplateReader capable of executing the read
     */
    public static TemplateReader reader() {
        return new TemplateReader();
    }

    /**
     * Converts a JSON String into a Template object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Template object represented by the provided JSON
     */
    public static Template fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Template.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Template object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Template object represented by the provided JSON
     */
    public static Template fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Template.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final Map<String, Object> translations;

    @JsonCreator
    private Template(@JsonProperty("sid")
                     final String sid,
                     @JsonProperty("account_sid")
                     final String accountSid,
                     @JsonProperty("friendly_name")
                     final String friendlyName,
                     @JsonProperty("translations")
                     final Map<String, Object> translations) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.translations = translations;
    }

    /**
     * Returns A string that uniquely identifies this Template.
     *
     * @return A string that uniquely identifies this Template
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns Account Sid.
     *
     * @return Account Sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns A string to describe the verification template.
     *
     * @return A string to describe the verification template
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns Object with the template translations..
     *
     * @return Object with the template translations.
     */
    public final Map<String, Object> getTranslations() {
        return this.translations;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Template other = (Template) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(translations, other.translations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            friendlyName,
                            translations);
    }
}