/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class AccessToken extends Resource {
    private static final long serialVersionUID = 108521635761261L;

    public enum FactorTypes {
        PUSH("push");

        private final String value;

        private FactorTypes(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a FactorTypes from a string.
         * @param value string value
         * @return generated FactorTypes
         */
        @JsonCreator
        public static FactorTypes forValue(final String value) {
            return Promoter.enumFromString(value, FactorTypes.values());
        }
    }

    /**
     * Create a AccessTokenCreator to execute create.
     *
     * @param pathServiceSid Service Sid.
     * @param identity Unique external identifier of the Entity
     * @param factorType The Type of this Factor
     * @return AccessTokenCreator capable of executing the create
     */
    public static AccessTokenCreator creator(final String pathServiceSid,
                                             final String identity,
                                             final AccessToken.FactorTypes factorType) {
        return new AccessTokenCreator(pathServiceSid, identity, factorType);
    }

    /**
     * Create a AccessTokenFetcher to execute fetch.
     *
     * @param pathServiceSid Service Sid.
     * @param pathSid A string that uniquely identifies this Access Token.
     * @return AccessTokenFetcher capable of executing the fetch
     */
    public static AccessTokenFetcher fetcher(final String pathServiceSid,
                                             final String pathSid) {
        return new AccessTokenFetcher(pathServiceSid, pathSid);
    }

    /**
     * Converts a JSON String into a AccessToken object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return AccessToken object represented by the provided JSON
     */
    public static AccessToken fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AccessToken.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a AccessToken object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return AccessToken object represented by the provided JSON
     */
    public static AccessToken fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AccessToken.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entityIdentity;
    private final AccessToken.FactorTypes factorType;
    private final String factorFriendlyName;
    private final String token;
    private final URI url;
    private final Integer ttl;
    private final ZonedDateTime dateCreated;

    @JsonCreator
    private AccessToken(@JsonProperty("sid")
                        final String sid,
                        @JsonProperty("account_sid")
                        final String accountSid,
                        @JsonProperty("service_sid")
                        final String serviceSid,
                        @JsonProperty("entity_identity")
                        final String entityIdentity,
                        @JsonProperty("factor_type")
                        final AccessToken.FactorTypes factorType,
                        @JsonProperty("factor_friendly_name")
                        final String factorFriendlyName,
                        @JsonProperty("token")
                        final String token,
                        @JsonProperty("url")
                        final URI url,
                        @JsonProperty("ttl")
                        final Integer ttl,
                        @JsonProperty("date_created")
                        final String dateCreated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entityIdentity = entityIdentity;
        this.factorType = factorType;
        this.factorFriendlyName = factorFriendlyName;
        this.token = token;
        this.url = url;
        this.ttl = ttl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
    }

    /**
     * Returns A string that uniquely identifies this Access Token..
     *
     * @return A string that uniquely identifies this Access Token.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns Account Sid..
     *
     * @return Account Sid.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns Verify Service Sid..
     *
     * @return Verify Service Sid.
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns Unique external identifier of the Entity.
     *
     * @return Unique external identifier of the Entity
     */
    public final String getEntityIdentity() {
        return this.entityIdentity;
    }

    /**
     * Returns The Type of the Factor.
     *
     * @return The Type of the Factor
     */
    public final AccessToken.FactorTypes getFactorType() {
        return this.factorType;
    }

    /**
     * Returns A human readable description of this factor..
     *
     * @return A human readable description of this factor.
     */
    public final String getFactorFriendlyName() {
        return this.factorFriendlyName;
    }

    /**
     * Returns Generated access token..
     *
     * @return Generated access token.
     */
    public final String getToken() {
        return this.token;
    }

    /**
     * Returns The URL of this resource..
     *
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns How long, in seconds, the access token is valid..
     *
     * @return How long, in seconds, the access token is valid.
     */
    public final Integer getTtl() {
        return this.ttl;
    }

    /**
     * Returns The date this access token was created.
     *
     * @return The date this access token was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AccessToken other = (AccessToken) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(serviceSid, other.serviceSid) &&
               Objects.equals(entityIdentity, other.entityIdentity) &&
               Objects.equals(factorType, other.factorType) &&
               Objects.equals(factorFriendlyName, other.factorFriendlyName) &&
               Objects.equals(token, other.token) &&
               Objects.equals(url, other.url) &&
               Objects.equals(ttl, other.ttl) &&
               Objects.equals(dateCreated, other.dateCreated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            serviceSid,
                            entityIdentity,
                            factorType,
                            factorFriendlyName,
                            token,
                            url,
                            ttl,
                            dateCreated);
    }
}