/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class MessagingConfigurationUpdater extends Updater<MessagingConfiguration> {
    private final String pathServiceSid;
    private final String pathCountry;
    private final String messagingServiceSid;

    /**
     * Construct a new MessagingConfigurationUpdater.
     *
     * @param pathServiceSid The SID of the Service that the resource is associated
     *                       with
     * @param pathCountry The ISO-3166-1 country code of the country or `all`.
     * @param messagingServiceSid The SID of the Messaging Service used for this
     *                            configuration.
     */
    public MessagingConfigurationUpdater(final String pathServiceSid,
                                         final String pathCountry,
                                         final String messagingServiceSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathCountry = pathCountry;
        this.messagingServiceSid = messagingServiceSid;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated MessagingConfiguration
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public MessagingConfiguration update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.VERIFY.toString(),
            "/v2/Services/" + this.pathServiceSid + "/MessagingConfigurations/" + this.pathCountry + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("MessagingConfiguration update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return MessagingConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", messagingServiceSid);
        }
    }
}