/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;
import java.util.Map;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class ChallengeUpdater extends Updater<Challenge> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathSid;
    private String authPayload;
    private Map<String, Object> metadata;

    /**
     * Construct a new ChallengeUpdater.
     *
     * @param pathServiceSid Service Sid.
     * @param pathIdentity Unique external identifier of the Entity
     * @param pathSid A string that uniquely identifies this Challenge.
     */
    public ChallengeUpdater(final String pathServiceSid,
                            final String pathIdentity,
                            final String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathSid = pathSid;
    }

    /**
     * The optional payload needed to verify the Challenge. E.g., a TOTP would use
     * the numeric code. For `TOTP` this value must be between 3 and 8 characters
     * long. For `Push` this value can be up to 5456 characters in length.
     *
     * @param authPayload Optional payload to verify the Challenge
     * @return this
     */
    public ChallengeUpdater setAuthPayload(final String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    /**
     * Custom metadata associated with the challenge. This is added by the
     * Device/SDK directly to allow for the inclusion of device information. It must
     * be a stringified JSON with only strings values eg. `{"os": "Android"}`. Can
     * be up to 1024 characters in length..
     *
     * @param metadata Metadata of the challenge.
     * @return this
     */
    public ChallengeUpdater setMetadata(final Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Challenge
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Challenge update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.VERIFY.toString(),
            "/v2/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Challenges/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Challenge update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Challenge.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (authPayload != null) {
            request.addPostParam("AuthPayload", authPayload);
        }

        if (metadata != null) {
            request.addPostParam("Metadata", Converter.mapToJson(metadata));
        }
    }
}