/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2.service.ratelimit;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class BucketFetcher extends Fetcher<Bucket> {
    private final String pathServiceSid;
    private final String pathRateLimitSid;
    private final String pathSid;

    /**
     * Construct a new BucketFetcher.
     *
     * @param pathServiceSid The SID of the Service that the resource is associated
     *                       with
     * @param pathRateLimitSid Rate Limit Sid.
     * @param pathSid A string that uniquely identifies this Bucket.
     */
    public BucketFetcher(final String pathServiceSid,
                         final String pathRateLimitSid,
                         final String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathRateLimitSid = pathRateLimitSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched Bucket
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Bucket fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.VERIFY.toString(),
            "/v2/Services/" + this.pathServiceSid + "/RateLimits/" + this.pathRateLimitSid + "/Buckets/" + this.pathSid + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Bucket fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Bucket.fromJson(response.getStream(), client.getObjectMapper());
    }
}