/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.video.v1.room;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

public class RecordingRulesUpdater extends Updater<RecordingRules> {
    private final String pathRoomSid;
    private Map<String, Object> rules;

    /**
     * Construct a new RecordingRulesUpdater.
     *
     * @param pathRoomSid The SID of the Room resource where the recording rules to
     *                    update apply
     */
    public RecordingRulesUpdater(final String pathRoomSid) {
        this.pathRoomSid = pathRoomSid;
    }

    /**
     * A JSON-encoded array of recording rules..
     *
     * @param rules A JSON-encoded array of recording rules
     * @return this
     */
    public RecordingRulesUpdater setRules(final Map<String, Object> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated RecordingRules
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public RecordingRules update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.VIDEO.toString(),
            "/v1/Rooms/" + this.pathRoomSid + "/RecordingRules"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("RecordingRules update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return RecordingRules.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (rules != null) {
            request.addPostParam("Rules", Converter.mapToJson(rules));
        }
    }
}