/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.voice.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ArchivedCall extends Resource {
    private static final long serialVersionUID = 77529505660808L;

    /**
     * Create a ArchivedCallDeleter to execute delete.
     *
     * @param pathDate The date of the Call in UTC.
     * @param pathSid The unique string that identifies this resource
     * @return ArchivedCallDeleter capable of executing the delete
     */
    public static ArchivedCallDeleter deleter(final LocalDate pathDate,
                                              final String pathSid) {
        return new ArchivedCallDeleter(pathDate, pathSid);
    }

    /**
     * Converts a JSON String into a ArchivedCall object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ArchivedCall object represented by the provided JSON
     */
    public static ArchivedCall fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ArchivedCall.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ArchivedCall object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ArchivedCall object represented by the provided JSON
     */
    public static ArchivedCall fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ArchivedCall.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final LocalDate date;
    private final String sid;
    private final URI url;

    @JsonCreator
    private ArchivedCall(@JsonProperty("date")
                         final String date,
                         @JsonProperty("sid")
                         final String sid,
                         @JsonProperty("url")
                         final URI url) {
        this.date = DateConverter.localDateFromString(date);
        this.sid = sid;
        this.url = url;
    }

    /**
     * Returns date.
     *
     * @return date
     */
    public final LocalDate getDate() {
        return this.date;
    }

    /**
     * Returns sid.
     *
     * @return sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ArchivedCall other = (ArchivedCall) o;

        return Objects.equals(date, other.date) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(date,
                            sid,
                            url);
    }
}