/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.voice.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class ByocTrunkCreator extends Creator<ByocTrunk> {
    private String friendlyName;
    private URI voiceUrl;
    private HttpMethod voiceMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceFallbackMethod;
    private URI statusCallbackUrl;
    private HttpMethod statusCallbackMethod;
    private Boolean cnamLookupEnabled;
    private String connectionPolicySid;
    private String fromDomainSid;

    /**
     * A descriptive string that you create to describe the resource. It is not
     * unique and can be up to 255 characters long..
     *
     * @param friendlyName A string to describe the resource
     * @return this
     */
    public ByocTrunkCreator setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The URL we should call when the BYOC Trunk receives a call..
     *
     * @param voiceUrl The URL we should call when receiving a call
     * @return this
     */
    public ByocTrunkCreator setVoiceUrl(final URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    /**
     * The URL we should call when the BYOC Trunk receives a call..
     *
     * @param voiceUrl The URL we should call when receiving a call
     * @return this
     */
    public ByocTrunkCreator setVoiceUrl(final String voiceUrl) {
        return setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    /**
     * The HTTP method we should use to call `voice_url`. Can be: `GET` or `POST`..
     *
     * @param voiceMethod The HTTP method to use with voice_url
     * @return this
     */
    public ByocTrunkCreator setVoiceMethod(final HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    /**
     * The URL that we should call when an error occurs while retrieving or
     * executing the TwiML from `voice_url`..
     *
     * @param voiceFallbackUrl The URL we should call when an error occurs in
     *                         executing TwiML
     * @return this
     */
    public ByocTrunkCreator setVoiceFallbackUrl(final URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    /**
     * The URL that we should call when an error occurs while retrieving or
     * executing the TwiML from `voice_url`..
     *
     * @param voiceFallbackUrl The URL we should call when an error occurs in
     *                         executing TwiML
     * @return this
     */
    public ByocTrunkCreator setVoiceFallbackUrl(final String voiceFallbackUrl) {
        return setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    /**
     * The HTTP method we should use to call `voice_fallback_url`. Can be: `GET` or
     * `POST`..
     *
     * @param voiceFallbackMethod The HTTP method to use with voice_fallback_url
     * @return this
     */
    public ByocTrunkCreator setVoiceFallbackMethod(final HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    /**
     * The URL that we should call to pass status parameters (such as call ended) to
     * your application..
     *
     * @param statusCallbackUrl The URL that we should call to pass status updates
     * @return this
     */
    public ByocTrunkCreator setStatusCallbackUrl(final URI statusCallbackUrl) {
        this.statusCallbackUrl = statusCallbackUrl;
        return this;
    }

    /**
     * The URL that we should call to pass status parameters (such as call ended) to
     * your application..
     *
     * @param statusCallbackUrl The URL that we should call to pass status updates
     * @return this
     */
    public ByocTrunkCreator setStatusCallbackUrl(final String statusCallbackUrl) {
        return setStatusCallbackUrl(Promoter.uriFromString(statusCallbackUrl));
    }

    /**
     * The HTTP method we should use to call `status_callback_url`. Can be: `GET` or
     * `POST`..
     *
     * @param statusCallbackMethod The HTTP method we should use to call
     *                             `status_callback_url`
     * @return this
     */
    public ByocTrunkCreator setStatusCallbackMethod(final HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    /**
     * Whether Caller ID Name (CNAM) lookup is enabled for the trunk. If enabled,
     * all inbound calls to the BYOC Trunk from the United States and Canada
     * automatically perform a CNAM Lookup and display Caller ID data on your phone.
     * See <a href="https://www.twilio.com/docs/sip-trunking#CNAM">CNAM Lookups</a>
     * for more information..
     *
     * @param cnamLookupEnabled Whether Caller ID Name (CNAM) lookup is enabled for
     *                          the trunk
     * @return this
     */
    public ByocTrunkCreator setCnamLookupEnabled(final Boolean cnamLookupEnabled) {
        this.cnamLookupEnabled = cnamLookupEnabled;
        return this;
    }

    /**
     * The SID of the Connection Policy that Twilio will use when routing traffic to
     * your communications infrastructure..
     *
     * @param connectionPolicySid Origination Connection Policy (to your Carrier)
     * @return this
     */
    public ByocTrunkCreator setConnectionPolicySid(final String connectionPolicySid) {
        this.connectionPolicySid = connectionPolicySid;
        return this;
    }

    /**
     * The SID of the SIP Domain that should be used in the `From` header of
     * originating calls sent to your SIP infrastructure. If your SIP infrastructure
     * allows users to "call back" an incoming call, configure this with a <a
     * href="https://www.twilio.com/docs/voice/api/sending-sip">SIP Domain</a> to
     * ensure proper routing. If not configured, the from domain will default to
     * "sip.twilio.com"..
     *
     * @param fromDomainSid The SID of the SIP Domain that should be used in the
     *                      `From` header of originating calls
     * @return this
     */
    public ByocTrunkCreator setFromDomainSid(final String fromDomainSid) {
        this.fromDomainSid = fromDomainSid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created ByocTrunk
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public ByocTrunk create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.VOICE.toString(),
            "/v1/ByocTrunks"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("ByocTrunk creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return ByocTrunk.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (voiceUrl != null) {
            request.addPostParam("VoiceUrl", voiceUrl.toString());
        }

        if (voiceMethod != null) {
            request.addPostParam("VoiceMethod", voiceMethod.toString());
        }

        if (voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", voiceFallbackUrl.toString());
        }

        if (voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", voiceFallbackMethod.toString());
        }

        if (statusCallbackUrl != null) {
            request.addPostParam("StatusCallbackUrl", statusCallbackUrl.toString());
        }

        if (statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", statusCallbackMethod.toString());
        }

        if (cnamLookupEnabled != null) {
            request.addPostParam("CnamLookupEnabled", cnamLookupEnabled.toString());
        }

        if (connectionPolicySid != null) {
            request.addPostParam("ConnectionPolicySid", connectionPolicySid);
        }

        if (fromDomainSid != null) {
            request.addPostParam("FromDomainSid", fromDomainSid);
        }
    }
}