/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.voice.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class SourceIpMapping extends Resource {
    private static final long serialVersionUID = 88517684058866L;

    /**
     * Create a SourceIpMappingCreator to execute create.
     *
     * @param ipRecordSid The unique string that identifies an IP Record
     * @param sipDomainSid The unique string that identifies a SIP Domain
     * @return SourceIpMappingCreator capable of executing the create
     */
    public static SourceIpMappingCreator creator(final String ipRecordSid,
                                                 final String sipDomainSid) {
        return new SourceIpMappingCreator(ipRecordSid, sipDomainSid);
    }

    /**
     * Create a SourceIpMappingFetcher to execute fetch.
     *
     * @param pathSid The unique string that identifies the resource
     * @return SourceIpMappingFetcher capable of executing the fetch
     */
    public static SourceIpMappingFetcher fetcher(final String pathSid) {
        return new SourceIpMappingFetcher(pathSid);
    }

    /**
     * Create a SourceIpMappingReader to execute read.
     *
     * @return SourceIpMappingReader capable of executing the read
     */
    public static SourceIpMappingReader reader() {
        return new SourceIpMappingReader();
    }

    /**
     * Create a SourceIpMappingUpdater to execute update.
     *
     * @param pathSid The unique string that identifies the resource
     * @param sipDomainSid The unique string that identifies a SIP Domain
     * @return SourceIpMappingUpdater capable of executing the update
     */
    public static SourceIpMappingUpdater updater(final String pathSid,
                                                 final String sipDomainSid) {
        return new SourceIpMappingUpdater(pathSid, sipDomainSid);
    }

    /**
     * Create a SourceIpMappingDeleter to execute delete.
     *
     * @param pathSid The unique string that identifies the resource
     * @return SourceIpMappingDeleter capable of executing the delete
     */
    public static SourceIpMappingDeleter deleter(final String pathSid) {
        return new SourceIpMappingDeleter(pathSid);
    }

    /**
     * Converts a JSON String into a SourceIpMapping object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return SourceIpMapping object represented by the provided JSON
     */
    public static SourceIpMapping fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, SourceIpMapping.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a SourceIpMapping object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return SourceIpMapping object represented by the provided JSON
     */
    public static SourceIpMapping fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, SourceIpMapping.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String ipRecordSid;
    private final String sipDomainSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private SourceIpMapping(@JsonProperty("sid")
                            final String sid,
                            @JsonProperty("ip_record_sid")
                            final String ipRecordSid,
                            @JsonProperty("sip_domain_sid")
                            final String sipDomainSid,
                            @JsonProperty("date_created")
                            final String dateCreated,
                            @JsonProperty("date_updated")
                            final String dateUpdated,
                            @JsonProperty("url")
                            final URI url) {
        this.sid = sid;
        this.ipRecordSid = ipRecordSid;
        this.sipDomainSid = sipDomainSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The unique string that identifies an IP Record.
     *
     * @return The unique string that identifies an IP Record
     */
    public final String getIpRecordSid() {
        return this.ipRecordSid;
    }

    /**
     * Returns The unique string that identifies a SIP Domain.
     *
     * @return The unique string that identifies a SIP Domain
     */
    public final String getSipDomainSid() {
        return this.sipDomainSid;
    }

    /**
     * Returns The RFC 2822 date and time in GMT that the resource was created.
     *
     * @return The RFC 2822 date and time in GMT that the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The RFC 2822 date and time in GMT that the resource was last updated.
     *
     * @return The RFC 2822 date and time in GMT that the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SourceIpMapping other = (SourceIpMapping) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(ipRecordSid, other.ipRecordSid) &&
               Objects.equals(sipDomainSid, other.sipDomainSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            ipRecordSid,
                            sipDomainSid,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}