/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.voice.v1.connectionpolicy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ConnectionPolicyTarget extends Resource {
    private static final long serialVersionUID = 215374980582138L;

    /**
     * Create a ConnectionPolicyTargetCreator to execute create.
     *
     * @param pathConnectionPolicySid The SID of the Connection Policy that owns
     *                                the Target
     * @param target The SIP address you want Twilio to route your calls to
     * @return ConnectionPolicyTargetCreator capable of executing the create
     */
    public static ConnectionPolicyTargetCreator creator(final String pathConnectionPolicySid,
                                                        final URI target) {
        return new ConnectionPolicyTargetCreator(pathConnectionPolicySid, target);
    }

    /**
     * Create a ConnectionPolicyTargetFetcher to execute fetch.
     *
     * @param pathConnectionPolicySid The SID of the Connection Policy that owns
     *                                the Target
     * @param pathSid The unique string that identifies the resource
     * @return ConnectionPolicyTargetFetcher capable of executing the fetch
     */
    public static ConnectionPolicyTargetFetcher fetcher(final String pathConnectionPolicySid,
                                                        final String pathSid) {
        return new ConnectionPolicyTargetFetcher(pathConnectionPolicySid, pathSid);
    }

    /**
     * Create a ConnectionPolicyTargetReader to execute read.
     *
     * @param pathConnectionPolicySid The SID of the Connection Policy from which
     *                                to read the Targets
     * @return ConnectionPolicyTargetReader capable of executing the read
     */
    public static ConnectionPolicyTargetReader reader(final String pathConnectionPolicySid) {
        return new ConnectionPolicyTargetReader(pathConnectionPolicySid);
    }

    /**
     * Create a ConnectionPolicyTargetUpdater to execute update.
     *
     * @param pathConnectionPolicySid The SID of the Connection Policy that owns
     *                                the Target
     * @param pathSid The unique string that identifies the resource
     * @return ConnectionPolicyTargetUpdater capable of executing the update
     */
    public static ConnectionPolicyTargetUpdater updater(final String pathConnectionPolicySid,
                                                        final String pathSid) {
        return new ConnectionPolicyTargetUpdater(pathConnectionPolicySid, pathSid);
    }

    /**
     * Create a ConnectionPolicyTargetDeleter to execute delete.
     *
     * @param pathConnectionPolicySid The SID of the Connection Policy that owns
     *                                the Target
     * @param pathSid The unique string that identifies the resource
     * @return ConnectionPolicyTargetDeleter capable of executing the delete
     */
    public static ConnectionPolicyTargetDeleter deleter(final String pathConnectionPolicySid,
                                                        final String pathSid) {
        return new ConnectionPolicyTargetDeleter(pathConnectionPolicySid, pathSid);
    }

    /**
     * Converts a JSON String into a ConnectionPolicyTarget object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ConnectionPolicyTarget object represented by the provided JSON
     */
    public static ConnectionPolicyTarget fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ConnectionPolicyTarget.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ConnectionPolicyTarget object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ConnectionPolicyTarget object represented by the provided JSON
     */
    public static ConnectionPolicyTarget fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ConnectionPolicyTarget.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String connectionPolicySid;
    private final String sid;
    private final String friendlyName;
    private final URI target;
    private final Integer priority;
    private final Integer weight;
    private final Boolean enabled;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private ConnectionPolicyTarget(@JsonProperty("account_sid")
                                   final String accountSid,
                                   @JsonProperty("connection_policy_sid")
                                   final String connectionPolicySid,
                                   @JsonProperty("sid")
                                   final String sid,
                                   @JsonProperty("friendly_name")
                                   final String friendlyName,
                                   @JsonProperty("target")
                                   final URI target,
                                   @JsonProperty("priority")
                                   final Integer priority,
                                   @JsonProperty("weight")
                                   final Integer weight,
                                   @JsonProperty("enabled")
                                   final Boolean enabled,
                                   @JsonProperty("date_created")
                                   final String dateCreated,
                                   @JsonProperty("date_updated")
                                   final String dateUpdated,
                                   @JsonProperty("url")
                                   final URI url) {
        this.accountSid = accountSid;
        this.connectionPolicySid = connectionPolicySid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.target = target;
        this.priority = priority;
        this.weight = weight;
        this.enabled = enabled;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Connection Policy that owns the Target.
     *
     * @return The SID of the Connection Policy that owns the Target
     */
    public final String getConnectionPolicySid() {
        return this.connectionPolicySid;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The string that you assigned to describe the resource.
     *
     * @return The string that you assigned to describe the resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The SIP address you want Twilio to route your calls to.
     *
     * @return The SIP address you want Twilio to route your calls to
     */
    public final URI getTarget() {
        return this.target;
    }

    /**
     * Returns The relative importance of the target.
     *
     * @return The relative importance of the target
     */
    public final Integer getPriority() {
        return this.priority;
    }

    /**
     * Returns The value that determines the relative load the Target should receive
     * compared to others with the same priority.
     *
     * @return The value that determines the relative load the Target should
     *         receive compared to others with the same priority
     */
    public final Integer getWeight() {
        return this.weight;
    }

    /**
     * Returns Whether the target is enabled.
     *
     * @return Whether the target is enabled
     */
    public final Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Returns The RFC 2822 date and time in GMT when the resource was created.
     *
     * @return The RFC 2822 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The RFC 2822 date and time in GMT when the resource was last updated.
     *
     * @return The RFC 2822 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ConnectionPolicyTarget other = (ConnectionPolicyTarget) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(connectionPolicySid, other.connectionPolicySid) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(target, other.target) &&
               Objects.equals(priority, other.priority) &&
               Objects.equals(weight, other.weight) &&
               Objects.equals(enabled, other.enabled) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            connectionPolicySid,
                            sid,
                            friendlyName,
                            target,
                            priority,
                            weight,
                            enabled,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}