/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.wireless.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class CommandCreator extends Creator<Command> {
    private final String command;
    private String sim;
    private HttpMethod callbackMethod;
    private URI callbackUrl;
    private Command.CommandMode commandMode;
    private String includeSid;
    private Boolean deliveryReceiptRequested;

    /**
     * Construct a new CommandCreator.
     *
     * @param command The message body of the Command or a Base64 encoded byte
     *                string in binary mode
     */
    public CommandCreator(final String command) {
        this.command = command;
    }

    /**
     * The `sid` or `unique_name` of the <a
     * href="https://www.twilio.com/docs/wireless/api/sim-resource">SIM</a> to send
     * the Command to..
     *
     * @param sim The sid or unique_name of the SIM to send the Command to
     * @return this
     */
    public CommandCreator setSim(final String sim) {
        this.sim = sim;
        return this;
    }

    /**
     * The HTTP method we use to call `callback_url`. Can be: `POST` or `GET`, and
     * the default is `POST`..
     *
     * @param callbackMethod The HTTP method we use to call callback_url
     * @return this
     */
    public CommandCreator setCallbackMethod(final HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    /**
     * The URL we call using the `callback_url` when the Command has finished
     * sending, whether the command was delivered or it failed..
     *
     * @param callbackUrl he URL we call when the Command has finished sending
     * @return this
     */
    public CommandCreator setCallbackUrl(final URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    /**
     * The URL we call using the `callback_url` when the Command has finished
     * sending, whether the command was delivered or it failed..
     *
     * @param callbackUrl he URL we call when the Command has finished sending
     * @return this
     */
    public CommandCreator setCallbackUrl(final String callbackUrl) {
        return setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    /**
     * The mode to use when sending the SMS message. Can be: `text` or `binary`. The
     * default SMS mode is `text`..
     *
     * @param commandMode The mode to use when sending the SMS message
     * @return this
     */
    public CommandCreator setCommandMode(final Command.CommandMode commandMode) {
        this.commandMode = commandMode;
        return this;
    }

    /**
     * Whether to include the SID of the command in the message body. Can be:
     * `none`, `start`, or `end`, and the default behavior is `none`. When sending a
     * Command to a SIM in text mode, we can automatically include the SID of the
     * Command in the message body, which could be used to ensure that the device
     * does not process the same Command more than once.  A value of `start` will
     * prepend the message with the Command SID, and `end` will append it to the
     * end, separating the Command SID from the message body with a space. The
     * length of the Command SID is included in the 160 character limit so the SMS
     * body must be 128 characters or less before the Command SID is included..
     *
     * @param includeSid Whether to include the SID of the command in the message
     *                   body
     * @return this
     */
    public CommandCreator setIncludeSid(final String includeSid) {
        this.includeSid = includeSid;
        return this;
    }

    /**
     * Whether to request delivery receipt from the recipient. For Commands that
     * request delivery receipt, the Command state transitions to 'delivered' once
     * the server has received a delivery receipt from the device. The default value
     * is `true`..
     *
     * @param deliveryReceiptRequested Whether to request delivery receipt from the
     *                                 recipient
     * @return this
     */
    public CommandCreator setDeliveryReceiptRequested(final Boolean deliveryReceiptRequested) {
        this.deliveryReceiptRequested = deliveryReceiptRequested;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Command
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Command create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.WIRELESS.toString(),
            "/v1/Commands"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Command creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Command.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (command != null) {
            request.addPostParam("Command", command);
        }

        if (sim != null) {
            request.addPostParam("Sim", sim);
        }

        if (callbackMethod != null) {
            request.addPostParam("CallbackMethod", callbackMethod.toString());
        }

        if (callbackUrl != null) {
            request.addPostParam("CallbackUrl", callbackUrl.toString());
        }

        if (commandMode != null) {
            request.addPostParam("CommandMode", commandMode.toString());
        }

        if (includeSid != null) {
            request.addPostParam("IncludeSid", includeSid);
        }

        if (deliveryReceiptRequested != null) {
            request.addPostParam("DeliveryReceiptRequested", deliveryReceiptRequested.toString());
        }
    }
}