/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.wireless.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class RatePlan extends Resource {
    private static final long serialVersionUID = 112752591577872L;

    public enum DataLimitStrategy {
        BLOCK("block"),
        THROTTLE("throttle");

        private final String value;

        private DataLimitStrategy(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a DataLimitStrategy from a string.
         * @param value string value
         * @return generated DataLimitStrategy
         */
        @JsonCreator
        public static DataLimitStrategy forValue(final String value) {
            return Promoter.enumFromString(value, DataLimitStrategy.values());
        }
    }

    /**
     * Create a RatePlanReader to execute read.
     *
     * @return RatePlanReader capable of executing the read
     */
    public static RatePlanReader reader() {
        return new RatePlanReader();
    }

    /**
     * Create a RatePlanFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return RatePlanFetcher capable of executing the fetch
     */
    public static RatePlanFetcher fetcher(final String pathSid) {
        return new RatePlanFetcher(pathSid);
    }

    /**
     * Create a RatePlanCreator to execute create.
     *
     * @return RatePlanCreator capable of executing the create
     */
    public static RatePlanCreator creator() {
        return new RatePlanCreator();
    }

    /**
     * Create a RatePlanUpdater to execute update.
     *
     * @param pathSid The SID that identifies the resource to update
     * @return RatePlanUpdater capable of executing the update
     */
    public static RatePlanUpdater updater(final String pathSid) {
        return new RatePlanUpdater(pathSid);
    }

    /**
     * Create a RatePlanDeleter to execute delete.
     *
     * @param pathSid The SID that identifies the resource to delete
     * @return RatePlanDeleter capable of executing the delete
     */
    public static RatePlanDeleter deleter(final String pathSid) {
        return new RatePlanDeleter(pathSid);
    }

    /**
     * Converts a JSON String into a RatePlan object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return RatePlan object represented by the provided JSON
     */
    public static RatePlan fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, RatePlan.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a RatePlan object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return RatePlan object represented by the provided JSON
     */
    public static RatePlan fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, RatePlan.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String friendlyName;
    private final Boolean dataEnabled;
    private final String dataMetering;
    private final Integer dataLimit;
    private final Boolean messagingEnabled;
    private final Boolean voiceEnabled;
    private final Boolean nationalRoamingEnabled;
    private final Integer nationalRoamingDataLimit;
    private final List<String> internationalRoaming;
    private final Integer internationalRoamingDataLimit;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private RatePlan(@JsonProperty("sid")
                     final String sid,
                     @JsonProperty("unique_name")
                     final String uniqueName,
                     @JsonProperty("account_sid")
                     final String accountSid,
                     @JsonProperty("friendly_name")
                     final String friendlyName,
                     @JsonProperty("data_enabled")
                     final Boolean dataEnabled,
                     @JsonProperty("data_metering")
                     final String dataMetering,
                     @JsonProperty("data_limit")
                     final Integer dataLimit,
                     @JsonProperty("messaging_enabled")
                     final Boolean messagingEnabled,
                     @JsonProperty("voice_enabled")
                     final Boolean voiceEnabled,
                     @JsonProperty("national_roaming_enabled")
                     final Boolean nationalRoamingEnabled,
                     @JsonProperty("national_roaming_data_limit")
                     final Integer nationalRoamingDataLimit,
                     @JsonProperty("international_roaming")
                     final List<String> internationalRoaming,
                     @JsonProperty("international_roaming_data_limit")
                     final Integer internationalRoamingDataLimit,
                     @JsonProperty("date_created")
                     final String dateCreated,
                     @JsonProperty("date_updated")
                     final String dateUpdated,
                     @JsonProperty("url")
                     final URI url) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dataEnabled = dataEnabled;
        this.dataMetering = dataMetering;
        this.dataLimit = dataLimit;
        this.messagingEnabled = messagingEnabled;
        this.voiceEnabled = voiceEnabled;
        this.nationalRoamingEnabled = nationalRoamingEnabled;
        this.nationalRoamingDataLimit = nationalRoamingDataLimit;
        this.internationalRoaming = internationalRoaming;
        this.internationalRoamingDataLimit = internationalRoamingDataLimit;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns An application-defined string that uniquely identifies the resource.
     *
     * @return An application-defined string that uniquely identifies the resource
     */
    public final String getUniqueName() {
        return this.uniqueName;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The string that you assigned to describe the resource.
     *
     * @return The string that you assigned to describe the resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns Whether SIMs can use GPRS/3G/4G/LTE data connectivity.
     *
     * @return Whether SIMs can use GPRS/3G/4G/LTE data connectivity
     */
    public final Boolean getDataEnabled() {
        return this.dataEnabled;
    }

    /**
     * Returns The model used to meter data usage.
     *
     * @return The model used to meter data usage
     */
    public final String getDataMetering() {
        return this.dataMetering;
    }

    /**
     * Returns The total data usage in Megabytes that the Network allows during one
     * month on the home network.
     *
     * @return The total data usage in Megabytes that the Network allows during one
     *         month on the home network
     */
    public final Integer getDataLimit() {
        return this.dataLimit;
    }

    /**
     * Returns Whether SIMs can make, send, and receive SMS using Commands.
     *
     * @return Whether SIMs can make, send, and receive SMS using Commands
     */
    public final Boolean getMessagingEnabled() {
        return this.messagingEnabled;
    }

    /**
     * Returns Deprecated. Whether SIMs can make and receive voice calls.
     *
     * @return Deprecated. Whether SIMs can make and receive voice calls
     */
    public final Boolean getVoiceEnabled() {
        return this.voiceEnabled;
    }

    /**
     * Returns Whether SIMs can roam on networks other than the home network in the
     * United States.
     *
     * @return Whether SIMs can roam on networks other than the home network in the
     *         United States
     */
    public final Boolean getNationalRoamingEnabled() {
        return this.nationalRoamingEnabled;
    }

    /**
     * Returns The total data usage in Megabytes that the Network allows during one
     * month on non-home networks in the United States.
     *
     * @return The total data usage in Megabytes that the Network allows during one
     *         month on non-home networks in the United States
     */
    public final Integer getNationalRoamingDataLimit() {
        return this.nationalRoamingDataLimit;
    }

    /**
     * Returns The services that SIMs capable of using GPRS/3G/4G/LTE data
     * connectivity can use outside of the United States.
     *
     * @return The services that SIMs capable of using GPRS/3G/4G/LTE data
     *         connectivity can use outside of the United States
     */
    public final List<String> getInternationalRoaming() {
        return this.internationalRoaming;
    }

    /**
     * Returns The total data usage (download and upload combined) in Megabytes that
     * the Network allows during one month when roaming outside the United States.
     *
     * @return The total data usage (download and upload combined) in Megabytes
     *         that the Network allows during one month when roaming outside the
     *         United States
     */
    public final Integer getInternationalRoamingDataLimit() {
        return this.internationalRoamingDataLimit;
    }

    /**
     * Returns The date when the resource was created, given as GMT in ISO 8601
     * format.
     *
     * @return The date when the resource was created, given as GMT in ISO 8601
     *         format
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The date when the resource was last updated, given as GMT in ISO 8601
     * format.
     *
     * @return The date when the resource was last updated, given as GMT in ISO
     *         8601 format
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        RatePlan other = (RatePlan) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(uniqueName, other.uniqueName) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(dataEnabled, other.dataEnabled) &&
               Objects.equals(dataMetering, other.dataMetering) &&
               Objects.equals(dataLimit, other.dataLimit) &&
               Objects.equals(messagingEnabled, other.messagingEnabled) &&
               Objects.equals(voiceEnabled, other.voiceEnabled) &&
               Objects.equals(nationalRoamingEnabled, other.nationalRoamingEnabled) &&
               Objects.equals(nationalRoamingDataLimit, other.nationalRoamingDataLimit) &&
               Objects.equals(internationalRoaming, other.internationalRoaming) &&
               Objects.equals(internationalRoamingDataLimit, other.internationalRoamingDataLimit) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            uniqueName,
                            accountSid,
                            friendlyName,
                            dataEnabled,
                            dataMetering,
                            dataLimit,
                            messagingEnabled,
                            voiceEnabled,
                            nationalRoamingEnabled,
                            nationalRoamingDataLimit,
                            internationalRoaming,
                            internationalRoamingDataLimit,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}