/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.fax.Receive;

/**
 * TwiML wrapper for {@code <Response>}
 */
@JsonDeserialize(builder = FaxResponse.Builder.class)
public class FaxResponse extends TwiML {
    /**
     * For XML Serialization/Deserialization
     */
    private FaxResponse() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Response>} element
     */
    private FaxResponse(Builder b) {
        super("Response", b);
    }

    /**
     * Create a new {@code <Response>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <FaxResponse.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a FaxResponse.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        /**
         * Add a child {@code <Receive>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "Receive")
        public Builder receive(Receive receive) {
            this.children.add(receive);
            return this;
        }

        /**
         * Create and return resulting {@code <Response>} element
         */
        public FaxResponse build() {
            return new FaxResponse(this);
        }
    }
}