/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Number>}
 */
@JsonDeserialize(builder = Number.Builder.class)
public class Number extends TwiML {
    public enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final String sendDigits;
    private final URI url;
    private final HttpMethod method;
    private final List<Number.Event> statusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String byoc;
    private final com.twilio.type.PhoneNumber phoneNumber;

    /**
     * For XML Serialization/Deserialization
     */
    private Number() {
        this(new Builder((com.twilio.type.PhoneNumber) null));
    }

    /**
     * Create a new {@code <Number>} element
     */
    private Number(Builder b) {
        super("Number", b);
        this.sendDigits = b.sendDigits;
        this.url = b.url;
        this.method = b.method;
        this.statusCallbackEvent = b.statusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.byoc = b.byoc;
        this.phoneNumber = b.phoneNumber;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getPhoneNumber() == null ? null : this.getPhoneNumber().toString();
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getSendDigits() != null) {
            attrs.put("sendDigits", this.getSendDigits());
        }
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getByoc() != null) {
            attrs.put("byoc", this.getByoc());
        }

        return attrs;
    }

    /**
     * DTMF tones to play when the call is answered
     *
     * @return DTMF tones to play when the call is answered
     */
    public String getSendDigits() {
        return sendDigits;
    }

    /**
     * TwiML URL
     *
     * @return TwiML URL
     */
    public URI getUrl() {
        return url;
    }

    /**
     * TwiML URL method
     *
     * @return TwiML URL method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * Events to call status callback
     *
     * @return Events to call status callback
     */
    public List<Number.Event> getStatusCallbackEvents() {
        return statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Number.Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (iter.hasNext()) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    /**
     * Status callback URL
     *
     * @return Status callback URL
     */
    public URI getStatusCallback() {
        return statusCallback;
    }

    /**
     * Status callback URL method
     *
     * @return Status callback URL method
     */
    public HttpMethod getStatusCallbackMethod() {
        return statusCallbackMethod;
    }

    /**
     * BYOC trunk SID (Beta)
     *
     * @return BYOC trunk SID (Beta)
     */
    public String getByoc() {
        return byoc;
    }

    /**
     * Phone Number to dial
     *
     * @return Phone Number to dial
     */
    public com.twilio.type.PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Create a new {@code <Number>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Number.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Number.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String sendDigits;
        private URI url;
        private HttpMethod method;
        private List<Number.Event> statusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private String byoc;
        private com.twilio.type.PhoneNumber phoneNumber;

        /**
         * Create a {@code <Number>} with phoneNumber
         */
        public Builder(com.twilio.type.PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        /**
         * Create a {@code <Number>} with phoneNumber
         */
        public Builder(String phoneNumber) {
            this.phoneNumber = Promoter.phoneNumberFromString(phoneNumber);
        }

        /**
         * Create a {@code <Number>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * DTMF tones to play when the call is answered
         */
        @JacksonXmlProperty(isAttribute = true, localName = "sendDigits")
        public Builder sendDigits(String sendDigits) {
            this.sendDigits = sendDigits;
            return this;
        }

        /**
         * TwiML URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        /**
         * TwiML URL
         */
        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        /**
         * TwiML URL method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Events to call status callback
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallbackEvent")
        public Builder statusCallbackEvents(List<Number.Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        /**
         * Events to call status callback
         */
        public Builder statusCallbackEvents(Number.Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        /**
         * Status callback URL
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        /**
         * Status callback URL
         */
        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        /**
         * Status callback URL method
         */
        @JacksonXmlProperty(isAttribute = true, localName = "statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        /**
         * BYOC trunk SID (Beta)
         */
        @JacksonXmlProperty(isAttribute = true, localName = "byoc")
        public Builder byoc(String byoc) {
            this.byoc = byoc;
            return this;
        }

        /**
         * Create and return resulting {@code <Number>} element
         */
        public Number build() {
            return new Number(this);
        }
    }
}