/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <emphasis>}
 */
@JsonDeserialize(builder = SsmlEmphasis.Builder.class)
public class SsmlEmphasis extends TwiML {
    public enum Level {
        STRONG("strong"),
        MODERATE("moderate"),
        REDUCED("reduced");

        private final String value;

        private Level(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final SsmlEmphasis.Level level;
    private final String words;

    /**
     * For XML Serialization/Deserialization
     */
    private SsmlEmphasis() {
        this(new Builder());
    }

    /**
     * Create a new {@code <emphasis>} element
     */
    private SsmlEmphasis(Builder b) {
        super("emphasis", b);
        this.level = b.level;
        this.words = b.words;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getLevel() != null) {
            attrs.put("level", this.getLevel().toString());
        }

        return attrs;
    }

    /**
     * Specify the degree of emphasis
     *
     * @return Specify the degree of emphasis
     */
    public SsmlEmphasis.Level getLevel() {
        return level;
    }

    /**
     * Words to emphasize
     *
     * @return Words to emphasize
     */
    public String getWords() {
        return words;
    }

    /**
     * Create a new {@code <emphasis>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <SsmlEmphasis.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a SsmlEmphasis.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private SsmlEmphasis.Level level;
        private String words;

        /**
         * Create a {@code <emphasis>} with words
         */
        public Builder(String words) {
            this.words = words;
        }

        /**
         * Create a {@code <emphasis>} with child elements
         */
        public Builder() {
        }

        /**
         * Specify the degree of emphasis
         */
        @JacksonXmlProperty(isAttribute = true, localName = "level")
        public Builder level(SsmlEmphasis.Level level) {
            this.level = level;
            return this;
        }

        /**
         * Add a child {@code <break>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "break")
        public Builder break_(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        /**
         * Add a child {@code <emphasis>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "emphasis")
        public Builder emphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        /**
         * Add a child {@code <lang>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "lang")
        public Builder lang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        /**
         * Add a child {@code <phoneme>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "phoneme")
        public Builder phoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        /**
         * Add a child {@code <prosody>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "prosody")
        public Builder prosody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        /**
         * Add a child {@code <say-as>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "say-as")
        public Builder sayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        /**
         * Add a child {@code <sub>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "sub")
        public Builder sub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        /**
         * Add a child {@code <w>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "w")
        public Builder w(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        /**
         * Create and return resulting {@code <emphasis>} element
         */
        public SsmlEmphasis build() {
            return new SsmlEmphasis(this);
        }
    }
}