/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <lang>}
 */
@JsonDeserialize(builder = SsmlLang.Builder.class)
public class SsmlLang extends TwiML {
    public enum XmlLang {
        DA_DK("da-DK"),
        NL_NL("nl-NL"),
        EN_AU("en-AU"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_US("en-US"),
        EN_GB_WLS("en-GB-WLS"),
        FR_FR("fr-FR"),
        FR_CA("fr-CA"),
        DE_DE("de-DE"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KO_KR("ko-KR"),
        NB_NO("nb-NO"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        RU_RU("ru-RU"),
        ES_ES("es-ES"),
        ES_US("es-US"),
        SV_SE("sv-SE"),
        TR_TR("tr-TR"),
        CY_GB("cy-GB");

        private final String value;

        private XmlLang(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final SsmlLang.XmlLang xmlLang;
    private final String words;

    /**
     * For XML Serialization/Deserialization
     */
    private SsmlLang() {
        this(new Builder());
    }

    /**
     * Create a new {@code <lang>} element
     */
    private SsmlLang(Builder b) {
        super("lang", b);
        this.xmlLang = b.xmlLang;
        this.words = b.words;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getXmlLang() != null) {
            attrs.put("xml:lang", this.getXmlLang().toString());
        }

        return attrs;
    }

    /**
     * Specify the language
     *
     * @return Specify the language
     */
    public SsmlLang.XmlLang getXmlLang() {
        return xmlLang;
    }

    /**
     * Words to speak
     *
     * @return Words to speak
     */
    public String getWords() {
        return words;
    }

    /**
     * Create a new {@code <lang>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <SsmlLang.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a SsmlLang.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private SsmlLang.XmlLang xmlLang;
        private String words;

        /**
         * Create a {@code <lang>} with words
         */
        public Builder(String words) {
            this.words = words;
        }

        /**
         * Create a {@code <lang>} with child elements
         */
        public Builder() {
        }

        /**
         * Specify the language
         */
        @JacksonXmlProperty(isAttribute = true, localName = "xml:lang")
        public Builder xmlLang(SsmlLang.XmlLang xmlLang) {
            this.xmlLang = xmlLang;
            return this;
        }

        /**
         * Add a child {@code <break>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "break")
        public Builder break_(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        /**
         * Add a child {@code <emphasis>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "emphasis")
        public Builder emphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        /**
         * Add a child {@code <lang>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "lang")
        public Builder lang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        /**
         * Add a child {@code <p>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "p")
        public Builder p(SsmlP ssmlP) {
            this.children.add(ssmlP);
            return this;
        }

        /**
         * Add a child {@code <phoneme>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "phoneme")
        public Builder phoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        /**
         * Add a child {@code <prosody>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "prosody")
        public Builder prosody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        /**
         * Add a child {@code <s>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "s")
        public Builder s(SsmlS ssmlS) {
            this.children.add(ssmlS);
            return this;
        }

        /**
         * Add a child {@code <say-as>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "say-as")
        public Builder sayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        /**
         * Add a child {@code <sub>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "sub")
        public Builder sub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        /**
         * Add a child {@code <w>} element
         */
        @JacksonXmlProperty(isAttribute = false, localName = "w")
        public Builder w(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        /**
         * Create and return resulting {@code <lang>} element
         */
        public SsmlLang build() {
            return new SsmlLang(this);
        }
    }
}