/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Application extends Resource {
    private static final long serialVersionUID = 30273898590025L;

    /**
     * Create a ApplicationCreator to execute create.
     *
     * @param pathAccountSid The SID of the Account that will create the resource
     * @return ApplicationCreator capable of executing the create
     */
    public static ApplicationCreator creator(final String pathAccountSid) {
        return new ApplicationCreator(pathAccountSid);
    }

    /**
     * Create a ApplicationCreator to execute create.
     *
     * @return ApplicationCreator capable of executing the create
     */
    public static ApplicationCreator creator() {
        return new ApplicationCreator();
    }

    /**
     * Create a ApplicationDeleter to execute delete.
     *
     * @param pathAccountSid The SID of the Account that created the resources to
     *                       delete
     * @param pathSid The unique string that identifies the resource
     * @return ApplicationDeleter capable of executing the delete
     */
    public static ApplicationDeleter deleter(final String pathAccountSid,
                                             final String pathSid) {
        return new ApplicationDeleter(pathAccountSid, pathSid);
    }

    /**
     * Create a ApplicationDeleter to execute delete.
     *
     * @param pathSid The unique string that identifies the resource
     * @return ApplicationDeleter capable of executing the delete
     */
    public static ApplicationDeleter deleter(final String pathSid) {
        return new ApplicationDeleter(pathSid);
    }

    /**
     * Create a ApplicationFetcher to execute fetch.
     *
     * @param pathAccountSid The SID of the Account that created the resource to
     *                       fetch
     * @param pathSid The unique string that identifies the resource
     * @return ApplicationFetcher capable of executing the fetch
     */
    public static ApplicationFetcher fetcher(final String pathAccountSid,
                                             final String pathSid) {
        return new ApplicationFetcher(pathAccountSid, pathSid);
    }

    /**
     * Create a ApplicationFetcher to execute fetch.
     *
     * @param pathSid The unique string that identifies the resource
     * @return ApplicationFetcher capable of executing the fetch
     */
    public static ApplicationFetcher fetcher(final String pathSid) {
        return new ApplicationFetcher(pathSid);
    }

    /**
     * Create a ApplicationReader to execute read.
     *
     * @param pathAccountSid The SID of the Account that created the resources to
     *                       read
     * @return ApplicationReader capable of executing the read
     */
    public static ApplicationReader reader(final String pathAccountSid) {
        return new ApplicationReader(pathAccountSid);
    }

    /**
     * Create a ApplicationReader to execute read.
     *
     * @return ApplicationReader capable of executing the read
     */
    public static ApplicationReader reader() {
        return new ApplicationReader();
    }

    /**
     * Create a ApplicationUpdater to execute update.
     *
     * @param pathAccountSid The SID of the Account that will create the resource
     * @param pathSid The unique string that identifies the resource
     * @return ApplicationUpdater capable of executing the update
     */
    public static ApplicationUpdater updater(final String pathAccountSid,
                                             final String pathSid) {
        return new ApplicationUpdater(pathAccountSid, pathSid);
    }

    /**
     * Create a ApplicationUpdater to execute update.
     *
     * @param pathSid The unique string that identifies the resource
     * @return ApplicationUpdater capable of executing the update
     */
    public static ApplicationUpdater updater(final String pathSid) {
        return new ApplicationUpdater(pathSid);
    }

    /**
     * Converts a JSON String into a Application object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Application object represented by the provided JSON
     */
    public static Application fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Application.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Application object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Application object represented by the provided JSON
     */
    public static Application fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Application.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String apiVersion;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final URI messageStatusCallback;
    private final String sid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsStatusCallback;
    private final URI smsUrl;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String uri;
    private final Boolean voiceCallerIdLookup;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceUrl;

    @JsonCreator
    private Application(@JsonProperty("account_sid")
                        final String accountSid,
                        @JsonProperty("api_version")
                        final String apiVersion,
                        @JsonProperty("date_created")
                        final String dateCreated,
                        @JsonProperty("date_updated")
                        final String dateUpdated,
                        @JsonProperty("friendly_name")
                        final String friendlyName,
                        @JsonProperty("message_status_callback")
                        final URI messageStatusCallback,
                        @JsonProperty("sid")
                        final String sid,
                        @JsonProperty("sms_fallback_method")
                        final HttpMethod smsFallbackMethod,
                        @JsonProperty("sms_fallback_url")
                        final URI smsFallbackUrl,
                        @JsonProperty("sms_method")
                        final HttpMethod smsMethod,
                        @JsonProperty("sms_status_callback")
                        final URI smsStatusCallback,
                        @JsonProperty("sms_url")
                        final URI smsUrl,
                        @JsonProperty("status_callback")
                        final URI statusCallback,
                        @JsonProperty("status_callback_method")
                        final HttpMethod statusCallbackMethod,
                        @JsonProperty("uri")
                        final String uri,
                        @JsonProperty("voice_caller_id_lookup")
                        final Boolean voiceCallerIdLookup,
                        @JsonProperty("voice_fallback_method")
                        final HttpMethod voiceFallbackMethod,
                        @JsonProperty("voice_fallback_url")
                        final URI voiceFallbackUrl,
                        @JsonProperty("voice_method")
                        final HttpMethod voiceMethod,
                        @JsonProperty("voice_url")
                        final URI voiceUrl) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.messageStatusCallback = messageStatusCallback;
        this.sid = sid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsStatusCallback = smsStatusCallback;
        this.smsUrl = smsUrl;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.uri = uri;
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceUrl = voiceUrl;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The API version used to start a new TwiML session.
     *
     * @return The API version used to start a new TwiML session
     */
    public final String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Returns The RFC 2822 date and time in GMT that the resource was created.
     *
     * @return The RFC 2822 date and time in GMT that the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The RFC 2822 date and time in GMT that the resource was last updated.
     *
     * @return The RFC 2822 date and time in GMT that the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The string that you assigned to describe the resource.
     *
     * @return The string that you assigned to describe the resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The URL to send message status information to your application.
     *
     * @return The URL to send message status information to your application
     */
    public final URI getMessageStatusCallback() {
        return this.messageStatusCallback;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The HTTP method used with sms_fallback_url.
     *
     * @return The HTTP method used with sms_fallback_url
     */
    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    /**
     * Returns The URL that we call when an error occurs while retrieving or
     * executing the TwiML.
     *
     * @return The URL that we call when an error occurs while retrieving or
     *         executing the TwiML
     */
    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    /**
     * Returns The HTTP method to use with sms_url.
     *
     * @return The HTTP method to use with sms_url
     */
    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    /**
     * Returns The URL to send status information to your application.
     *
     * @return The URL to send status information to your application
     */
    public final URI getSmsStatusCallback() {
        return this.smsStatusCallback;
    }

    /**
     * Returns The URL we call when the phone number receives an incoming SMS
     * message.
     *
     * @return The URL we call when the phone number receives an incoming SMS
     *         message
     */
    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    /**
     * Returns The URL to send status information to your application.
     *
     * @return The URL to send status information to your application
     */
    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    /**
     * Returns The HTTP method we use to call status_callback.
     *
     * @return The HTTP method we use to call status_callback
     */
    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    /**
     * Returns The URI of the resource, relative to `https://api.twilio.com`.
     *
     * @return The URI of the resource, relative to `https://api.twilio.com`
     */
    public final String getUri() {
        return this.uri;
    }

    /**
     * Returns Whether to lookup the caller's name.
     *
     * @return Whether to lookup the caller's name
     */
    public final Boolean getVoiceCallerIdLookup() {
        return this.voiceCallerIdLookup;
    }

    /**
     * Returns The HTTP method used with voice_fallback_url.
     *
     * @return The HTTP method used with voice_fallback_url
     */
    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    /**
     * Returns The URL we call when a TwiML error occurs.
     *
     * @return The URL we call when a TwiML error occurs
     */
    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    /**
     * Returns The HTTP method used with the voice_url.
     *
     * @return The HTTP method used with the voice_url
     */
    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    /**
     * Returns The URL we call when the phone number receives a call.
     *
     * @return The URL we call when the phone number receives a call
     */
    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Application other = (Application) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(apiVersion, other.apiVersion) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(messageStatusCallback, other.messageStatusCallback) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(smsFallbackMethod, other.smsFallbackMethod) &&
               Objects.equals(smsFallbackUrl, other.smsFallbackUrl) &&
               Objects.equals(smsMethod, other.smsMethod) &&
               Objects.equals(smsStatusCallback, other.smsStatusCallback) &&
               Objects.equals(smsUrl, other.smsUrl) &&
               Objects.equals(statusCallback, other.statusCallback) &&
               Objects.equals(statusCallbackMethod, other.statusCallbackMethod) &&
               Objects.equals(uri, other.uri) &&
               Objects.equals(voiceCallerIdLookup, other.voiceCallerIdLookup) &&
               Objects.equals(voiceFallbackMethod, other.voiceFallbackMethod) &&
               Objects.equals(voiceFallbackUrl, other.voiceFallbackUrl) &&
               Objects.equals(voiceMethod, other.voiceMethod) &&
               Objects.equals(voiceUrl, other.voiceUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            apiVersion,
                            dateCreated,
                            dateUpdated,
                            friendlyName,
                            messageStatusCallback,
                            sid,
                            smsFallbackMethod,
                            smsFallbackUrl,
                            smsMethod,
                            smsStatusCallback,
                            smsUrl,
                            statusCallback,
                            statusCallbackMethod,
                            uri,
                            voiceCallerIdLookup,
                            voiceFallbackMethod,
                            voiceFallbackUrl,
                            voiceMethod,
                            voiceUrl);
    }
}