/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Conference extends Resource {
    private static final long serialVersionUID = 34504755798279L;

    public enum Status {
        INIT("init"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum UpdateStatus {
        COMPLETED("completed");

        private final String value;

        private UpdateStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a UpdateStatus from a string.
         * @param value string value
         * @return generated UpdateStatus
         */
        @JsonCreator
        public static UpdateStatus forValue(final String value) {
            return Promoter.enumFromString(value, UpdateStatus.values());
        }
    }

    public enum ReasonConferenceEnded {
        CONFERENCE_ENDED_VIA_API("conference-ended-via-api"),
        PARTICIPANT_WITH_END_CONFERENCE_ON_EXIT_LEFT("participant-with-end-conference-on-exit-left"),
        PARTICIPANT_WITH_END_CONFERENCE_ON_EXIT_KICKED("participant-with-end-conference-on-exit-kicked"),
        LAST_PARTICIPANT_KICKED("last-participant-kicked"),
        LAST_PARTICIPANT_LEFT("last-participant-left");

        private final String value;

        private ReasonConferenceEnded(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a ReasonConferenceEnded from a string.
         * @param value string value
         * @return generated ReasonConferenceEnded
         */
        @JsonCreator
        public static ReasonConferenceEnded forValue(final String value) {
            return Promoter.enumFromString(value, ReasonConferenceEnded.values());
        }
    }

    /**
     * Create a ConferenceFetcher to execute fetch.
     *
     * @param pathAccountSid The SID of the Account that created the resource(s) to
     *                       fetch
     * @param pathSid The unique string that identifies this resource
     * @return ConferenceFetcher capable of executing the fetch
     */
    public static ConferenceFetcher fetcher(final String pathAccountSid,
                                            final String pathSid) {
        return new ConferenceFetcher(pathAccountSid, pathSid);
    }

    /**
     * Create a ConferenceFetcher to execute fetch.
     *
     * @param pathSid The unique string that identifies this resource
     * @return ConferenceFetcher capable of executing the fetch
     */
    public static ConferenceFetcher fetcher(final String pathSid) {
        return new ConferenceFetcher(pathSid);
    }

    /**
     * Create a ConferenceReader to execute read.
     *
     * @param pathAccountSid The SID of the Account that created the resource(s) to
     *                       read
     * @return ConferenceReader capable of executing the read
     */
    public static ConferenceReader reader(final String pathAccountSid) {
        return new ConferenceReader(pathAccountSid);
    }

    /**
     * Create a ConferenceReader to execute read.
     *
     * @return ConferenceReader capable of executing the read
     */
    public static ConferenceReader reader() {
        return new ConferenceReader();
    }

    /**
     * Create a ConferenceUpdater to execute update.
     *
     * @param pathAccountSid The SID of the Account that created the resource(s) to
     *                       update
     * @param pathSid The unique string that identifies this resource
     * @return ConferenceUpdater capable of executing the update
     */
    public static ConferenceUpdater updater(final String pathAccountSid,
                                            final String pathSid) {
        return new ConferenceUpdater(pathAccountSid, pathSid);
    }

    /**
     * Create a ConferenceUpdater to execute update.
     *
     * @param pathSid The unique string that identifies this resource
     * @return ConferenceUpdater capable of executing the update
     */
    public static ConferenceUpdater updater(final String pathSid) {
        return new ConferenceUpdater(pathSid);
    }

    /**
     * Converts a JSON String into a Conference object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Conference object represented by the provided JSON
     */
    public static Conference fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Conference.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Conference object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Conference object represented by the provided JSON
     */
    public static Conference fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Conference.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String apiVersion;
    private final String friendlyName;
    private final String region;
    private final String sid;
    private final Conference.Status status;
    private final String uri;
    private final Map<String, String> subresourceUris;
    private final Conference.ReasonConferenceEnded reasonConferenceEnded;
    private final String callSidEndingConference;

    @JsonCreator
    private Conference(@JsonProperty("account_sid")
                       final String accountSid,
                       @JsonProperty("date_created")
                       final String dateCreated,
                       @JsonProperty("date_updated")
                       final String dateUpdated,
                       @JsonProperty("api_version")
                       final String apiVersion,
                       @JsonProperty("friendly_name")
                       final String friendlyName,
                       @JsonProperty("region")
                       final String region,
                       @JsonProperty("sid")
                       final String sid,
                       @JsonProperty("status")
                       final Conference.Status status,
                       @JsonProperty("uri")
                       final String uri,
                       @JsonProperty("subresource_uris")
                       final Map<String, String> subresourceUris,
                       @JsonProperty("reason_conference_ended")
                       final Conference.ReasonConferenceEnded reasonConferenceEnded,
                       @JsonProperty("call_sid_ending_conference")
                       final String callSidEndingConference) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.apiVersion = apiVersion;
        this.friendlyName = friendlyName;
        this.region = region;
        this.sid = sid;
        this.status = status;
        this.uri = uri;
        this.subresourceUris = subresourceUris;
        this.reasonConferenceEnded = reasonConferenceEnded;
        this.callSidEndingConference = callSidEndingConference;
    }

    /**
     * Returns The SID of the Account that created this resource.
     *
     * @return The SID of the Account that created this resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The RFC 2822 date and time in GMT that this resource was created.
     *
     * @return The RFC 2822 date and time in GMT that this resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The RFC 2822 date and time in GMT that this resource was last
     * updated.
     *
     * @return The RFC 2822 date and time in GMT that this resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The API version used to create this conference.
     *
     * @return The API version used to create this conference
     */
    public final String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Returns A string that you assigned to describe this conference room.
     *
     * @return A string that you assigned to describe this conference room
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns A string that represents the Twilio Region where the conference was
     * mixed.
     *
     * @return A string that represents the Twilio Region where the conference was
     *         mixed
     */
    public final String getRegion() {
        return this.region;
    }

    /**
     * Returns The unique string that identifies this resource.
     *
     * @return The unique string that identifies this resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The status of this conference.
     *
     * @return The status of this conference
     */
    public final Conference.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The URI of this resource, relative to `https://api.twilio.com`.
     *
     * @return The URI of this resource, relative to `https://api.twilio.com`
     */
    public final String getUri() {
        return this.uri;
    }

    /**
     * Returns A list of related resources identified by their relative URIs.
     *
     * @return A list of related resources identified by their relative URIs
     */
    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    /**
     * Returns The reason why a conference ended..
     *
     * @return The reason why a conference ended.
     */
    public final Conference.ReasonConferenceEnded getReasonConferenceEnded() {
        return this.reasonConferenceEnded;
    }

    /**
     * Returns The call SID that caused the conference to end.
     *
     * @return The call SID that caused the conference to end
     */
    public final String getCallSidEndingConference() {
        return this.callSidEndingConference;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Conference other = (Conference) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(apiVersion, other.apiVersion) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(region, other.region) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(status, other.status) &&
               Objects.equals(uri, other.uri) &&
               Objects.equals(subresourceUris, other.subresourceUris) &&
               Objects.equals(reasonConferenceEnded, other.reasonConferenceEnded) &&
               Objects.equals(callSidEndingConference, other.callSidEndingConference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            dateCreated,
                            dateUpdated,
                            apiVersion,
                            friendlyName,
                            region,
                            sid,
                            status,
                            uri,
                            subresourceUris,
                            reasonConferenceEnded,
                            callSidEndingConference);
    }
}