/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class RecordingFetcher extends Fetcher<Recording> {
    private String pathAccountSid;
    private final String pathSid;
    private Boolean includeSoftDeleted;

    /**
     * Construct a new RecordingFetcher.
     *
     * @param pathSid The unique string that identifies the resource
     */
    public RecordingFetcher(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Construct a new RecordingFetcher.
     *
     * @param pathAccountSid The SID of the Account that created the resource to
     *                       fetch
     * @param pathSid The unique string that identifies the resource
     */
    public RecordingFetcher(final String pathAccountSid,
                            final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    /**
     * A boolean parameter indicating whether to retrieve soft deleted recordings or
     * not. Recordings metadata are kept after deletion for a retention period of 40
     * days..
     *
     * @param includeSoftDeleted A boolean parameter indicating whether to retrieve
     *                           soft deleted recordings or not.
     * @return this
     */
    public RecordingFetcher setIncludeSoftDeleted(final Boolean includeSoftDeleted) {
        this.includeSoftDeleted = includeSoftDeleted;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched Recording
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Recording fetch(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.GET,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Recordings/" + this.pathSid + ".json"
        );

        addQueryParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Recording fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (includeSoftDeleted != null) {
            request.addQueryParam("IncludeSoftDeleted", includeSoftDeleted.toString());
        }
    }
}