/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Creator;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;
import java.time.LocalDate;

public class FeedbackSummaryCreator extends Creator<FeedbackSummary> {
    private String pathAccountSid;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private Boolean includeSubaccounts;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;

    /**
     * Construct a new FeedbackSummaryCreator.
     *
     * @param startDate Only include feedback given on or after this date
     * @param endDate Only include feedback given on or before this date
     */
    public FeedbackSummaryCreator(final LocalDate startDate,
                                  final LocalDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    /**
     * Construct a new FeedbackSummaryCreator.
     *
     * @param pathAccountSid The unique sid that identifies this account
     * @param startDate Only include feedback given on or after this date
     * @param endDate Only include feedback given on or before this date
     */
    public FeedbackSummaryCreator(final String pathAccountSid,
                                  final LocalDate startDate,
                                  final LocalDate endDate) {
        this.pathAccountSid = pathAccountSid;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    /**
     * Whether to also include Feedback resources from all subaccounts. `true`
     * includes feedback from all subaccounts and `false`, the default, includes
     * feedback from only the specified account..
     *
     * @param includeSubaccounts `true` includes feedback from the specified
     *                           account and its subaccounts
     * @return this
     */
    public FeedbackSummaryCreator setIncludeSubaccounts(final Boolean includeSubaccounts) {
        this.includeSubaccounts = includeSubaccounts;
        return this;
    }

    /**
     * The URL that we will request when the feedback summary is complete..
     *
     * @param statusCallback The URL that we will request when the feedback summary
     *                       is complete
     * @return this
     */
    public FeedbackSummaryCreator setStatusCallback(final URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    /**
     * The URL that we will request when the feedback summary is complete..
     *
     * @param statusCallback The URL that we will request when the feedback summary
     *                       is complete
     * @return this
     */
    public FeedbackSummaryCreator setStatusCallback(final String statusCallback) {
        return setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    /**
     * The HTTP method (`GET` or `POST`) we use to make the request to the
     * `StatusCallback` URL..
     *
     * @param statusCallbackMethod The HTTP method we use to make requests to the
     *                             StatusCallback URL
     * @return this
     */
    public FeedbackSummaryCreator setStatusCallbackMethod(final HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created FeedbackSummary
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public FeedbackSummary create(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Calls/FeedbackSummary.json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("FeedbackSummary creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return FeedbackSummary.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (startDate != null) {
            request.addPostParam("StartDate", DateConverter.dateStringFromLocalDate(startDate));
        }

        if (endDate != null) {
            request.addPostParam("EndDate", DateConverter.dateStringFromLocalDate(endDate));
        }

        if (includeSubaccounts != null) {
            request.addPostParam("IncludeSubaccounts", includeSubaccounts.toString());
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }

        if (statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", statusCallbackMethod.toString());
        }
    }
}