/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class PaymentUpdater extends Updater<Payment> {
    private String pathAccountSid;
    private final String pathCallSid;
    private final String pathSid;
    private final String idempotencyKey;
    private final URI statusCallback;
    private Payment.Capture capture;
    private Payment.Status status;

    /**
     * Construct a new PaymentUpdater.
     *
     * @param pathCallSid The SID of the call that will create the resource.
     * @param pathSid The SID of Payments session
     * @param idempotencyKey A unique token that will be used to ensure that
     *                       multiple API calls with the same information do not
     *                       result in multiple transactions.
     * @param statusCallback Provide an absolute or relative URL to receive status
     *                       updates regarding your Pay session.
     */
    public PaymentUpdater(final String pathCallSid,
                          final String pathSid,
                          final String idempotencyKey,
                          final URI statusCallback) {
        this.pathCallSid = pathCallSid;
        this.pathSid = pathSid;
        this.idempotencyKey = idempotencyKey;
        this.statusCallback = statusCallback;
    }

    /**
     * Construct a new PaymentUpdater.
     *
     * @param pathAccountSid The SID of the Account that will update the resource
     * @param pathCallSid The SID of the call that will create the resource.
     * @param pathSid The SID of Payments session
     * @param idempotencyKey A unique token that will be used to ensure that
     *                       multiple API calls with the same information do not
     *                       result in multiple transactions.
     * @param statusCallback Provide an absolute or relative URL to receive status
     *                       updates regarding your Pay session.
     */
    public PaymentUpdater(final String pathAccountSid,
                          final String pathCallSid,
                          final String pathSid,
                          final String idempotencyKey,
                          final URI statusCallback) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
        this.pathSid = pathSid;
        this.idempotencyKey = idempotencyKey;
        this.statusCallback = statusCallback;
    }

    /**
     * The piece of payment information that you wish the caller to enter. Must be
     * one of `payment-card-number`, `expiration-date`, `security-code`,
     * `postal-code`, `bank-routing-number`, or `bank-account-number`..
     *
     * @param capture The piece of payment information that you wish the caller to
     *                enter.
     * @return this
     */
    public PaymentUpdater setCapture(final Payment.Capture capture) {
        this.capture = capture;
        return this;
    }

    /**
     * Indicates whether the current payment session should be cancelled or
     * completed. When `cancel` the payment session is cancelled. When `complete`,
     * Twilio sends the payment information to the selected &lt;Pay&gt; connector
     * for processing..
     *
     * @param status Indicates whether the current payment session should be
     *               cancelled or completed.
     * @return this
     */
    public PaymentUpdater setStatus(final Payment.Status status) {
        this.status = status;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Payment
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Payment update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Calls/" + this.pathCallSid + "/Payments/" + this.pathSid + ".json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Payment update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Payment.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (idempotencyKey != null) {
            request.addPostParam("IdempotencyKey", idempotencyKey);
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }

        if (capture != null) {
            request.addPostParam("Capture", capture.toString());
        }

        if (status != null) {
            request.addPostParam("Status", status.toString());
        }
    }
}