/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class SiprecUpdater extends Updater<Siprec> {
    private String pathAccountSid;
    private final String pathCallSid;
    private final String pathSid;
    private final Siprec.UpdateStatus status;

    /**
     * Construct a new SiprecUpdater.
     *
     * @param pathCallSid The SID of the Call the resource is associated with
     * @param pathSid The SID of the Siprec resource, or the `name`
     * @param status The status. Must have the value `stopped`
     */
    public SiprecUpdater(final String pathCallSid,
                         final String pathSid,
                         final Siprec.UpdateStatus status) {
        this.pathCallSid = pathCallSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    /**
     * Construct a new SiprecUpdater.
     *
     * @param pathAccountSid The SID of the Account that created this resource
     * @param pathCallSid The SID of the Call the resource is associated with
     * @param pathSid The SID of the Siprec resource, or the `name`
     * @param status The status. Must have the value `stopped`
     */
    public SiprecUpdater(final String pathAccountSid,
                         final String pathCallSid,
                         final String pathSid,
                         final Siprec.UpdateStatus status) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Siprec
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Siprec update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Calls/" + this.pathCallSid + "/Siprec/" + this.pathSid + ".json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Siprec update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Siprec.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (status != null) {
            request.addPostParam("Status", status.toString());
        }
    }
}