/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class AssignedAddOnFetcher extends Fetcher<AssignedAddOn> {
    private String pathAccountSid;
    private final String pathResourceSid;
    private final String pathSid;

    /**
     * Construct a new AssignedAddOnFetcher.
     *
     * @param pathResourceSid The SID of the Phone Number that installed this Add-on
     * @param pathSid The unique string that identifies the resource
     */
    public AssignedAddOnFetcher(final String pathResourceSid,
                                final String pathSid) {
        this.pathResourceSid = pathResourceSid;
        this.pathSid = pathSid;
    }

    /**
     * Construct a new AssignedAddOnFetcher.
     *
     * @param pathAccountSid The SID of the Account that created the resource to
     *                       fetch
     * @param pathResourceSid The SID of the Phone Number that installed this Add-on
     * @param pathSid The unique string that identifies the resource
     */
    public AssignedAddOnFetcher(final String pathAccountSid,
                                final String pathResourceSid,
                                final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathResourceSid = pathResourceSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched AssignedAddOn
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public AssignedAddOn fetch(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.GET,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/IncomingPhoneNumbers/" + this.pathResourceSid + "/AssignedAddOns/" + this.pathSid + ".json"
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("AssignedAddOn fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return AssignedAddOn.fromJson(response.getStream(), client.getObjectMapper());
    }
}