/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.message;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class FeedbackCreator extends Creator<Feedback> {
    private String pathAccountSid;
    private final String pathMessageSid;
    private Feedback.Outcome outcome;

    /**
     * Construct a new FeedbackCreator.
     *
     * @param pathMessageSid The SID of the Message resource for which the feedback
     *                       was provided
     */
    public FeedbackCreator(final String pathMessageSid) {
        this.pathMessageSid = pathMessageSid;
    }

    /**
     * Construct a new FeedbackCreator.
     *
     * @param pathAccountSid The SID of the Account that will create the resource
     * @param pathMessageSid The SID of the Message resource for which the feedback
     *                       was provided
     */
    public FeedbackCreator(final String pathAccountSid,
                           final String pathMessageSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathMessageSid = pathMessageSid;
    }

    /**
     * Whether the feedback has arrived. Can be: `unconfirmed` or `confirmed`. If
     * `provide_feedback`=`true` in <a
     * href="https://www.twilio.com/docs/sms/api/message-resource#create-a-message-resource">the
     * initial HTTP POST</a>, the initial value of this property is `unconfirmed`.
     * After the message arrives, update the value to `confirmed`..
     *
     * @param outcome Whether the feedback has arrived
     * @return this
     */
    public FeedbackCreator setOutcome(final Feedback.Outcome outcome) {
        this.outcome = outcome;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Feedback
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Feedback create(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Messages/" + this.pathMessageSid + "/Feedback.json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Feedback creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Feedback.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (outcome != null) {
            request.addPostParam("Outcome", outcome.toString());
        }
    }
}