/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.sip.credentiallist;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class CredentialUpdater extends Updater<Credential> {
    private String pathAccountSid;
    private final String pathCredentialListSid;
    private final String pathSid;
    private String password;

    /**
     * Construct a new CredentialUpdater.
     *
     * @param pathCredentialListSid The unique id that identifies the credential
     *                              list that includes this credential
     * @param pathSid The unique id that identifies the resource to update
     */
    public CredentialUpdater(final String pathCredentialListSid,
                             final String pathSid) {
        this.pathCredentialListSid = pathCredentialListSid;
        this.pathSid = pathSid;
    }

    /**
     * Construct a new CredentialUpdater.
     *
     * @param pathAccountSid The unique id of the Account that is responsible for
     *                       this resource
     * @param pathCredentialListSid The unique id that identifies the credential
     *                              list that includes this credential
     * @param pathSid The unique id that identifies the resource to update
     */
    public CredentialUpdater(final String pathAccountSid,
                             final String pathCredentialListSid,
                             final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathCredentialListSid = pathCredentialListSid;
        this.pathSid = pathSid;
    }

    /**
     * The password that the username will use when authenticating SIP requests. The
     * password must be a minimum of 12 characters, contain at least 1 digit, and
     * have mixed case. (eg `IWasAtSignal2018`).
     *
     * @param password The password will not be returned in the response
     * @return this
     */
    public CredentialUpdater setPassword(final String password) {
        this.password = password;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Credential
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Credential update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/CredentialLists/" + this.pathCredentialListSid + "/Credentials/" + this.pathSid + ".json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Credential update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Credential.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (password != null) {
            request.addPostParam("Password", password);
        }
    }
}