/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class IpAddressFetcher extends Fetcher<IpAddress> {
    private String pathAccountSid;
    private final String pathIpAccessControlListSid;
    private final String pathSid;

    /**
     * Construct a new IpAddressFetcher.
     *
     * @param pathIpAccessControlListSid The IpAccessControlList Sid that
     *                                   identifies the IpAddress resources to fetch
     * @param pathSid A string that identifies the IpAddress resource to fetch
     */
    public IpAddressFetcher(final String pathIpAccessControlListSid,
                            final String pathSid) {
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
        this.pathSid = pathSid;
    }

    /**
     * Construct a new IpAddressFetcher.
     *
     * @param pathAccountSid The unique sid that identifies this account
     * @param pathIpAccessControlListSid The IpAccessControlList Sid that
     *                                   identifies the IpAddress resources to fetch
     * @param pathSid A string that identifies the IpAddress resource to fetch
     */
    public IpAddressFetcher(final String pathAccountSid,
                            final String pathIpAccessControlListSid,
                            final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched IpAddress
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public IpAddress fetch(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.GET,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/IpAccessControlLists/" + this.pathIpAccessControlListSid + "/IpAddresses/" + this.pathSid + ".json"
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("IpAddress fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return IpAddress.fromJson(response.getStream(), client.getObjectMapper());
    }
}