/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;
import java.util.Map;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class TaskUpdater extends Updater<Task> {
    private final String pathAssistantSid;
    private final String pathSid;
    private String friendlyName;
    private String uniqueName;
    private Map<String, Object> actions;
    private URI actionsUrl;

    /**
     * Construct a new TaskUpdater.
     *
     * @param pathAssistantSid The SID of the Assistant that is the parent of the
     *                         resource to update
     * @param pathSid The unique string that identifies the resource
     */
    public TaskUpdater(final String pathAssistantSid,
                       final String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathSid = pathSid;
    }

    /**
     * A descriptive string that you create to describe the resource. It is not
     * unique and can be up to 255 characters long..
     *
     * @param friendlyName A string to describe the resource
     * @return this
     */
    public TaskUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * An application-defined string that uniquely identifies the resource. This
     * value must be 64 characters or less in length and be unique. It can be used
     * as an alternative to the `sid` in the URL path to address the resource..
     *
     * @param uniqueName An application-defined string that uniquely identifies the
     *                   resource
     * @return this
     */
    public TaskUpdater setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    /**
     * The JSON string that specifies the <a
     * href="https://www.twilio.com/docs/autopilot/actions">actions</a> that
     * instruct the Assistant on how to perform the task..
     *
     * @param actions The JSON string that specifies the actions that instruct the
     *                Assistant on how to perform the task
     * @return this
     */
    public TaskUpdater setActions(final Map<String, Object> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * The URL from which the Assistant can fetch actions..
     *
     * @param actionsUrl The URL from which the Assistant can fetch actions
     * @return this
     */
    public TaskUpdater setActionsUrl(final URI actionsUrl) {
        this.actionsUrl = actionsUrl;
        return this;
    }

    /**
     * The URL from which the Assistant can fetch actions..
     *
     * @param actionsUrl The URL from which the Assistant can fetch actions
     * @return this
     */
    public TaskUpdater setActionsUrl(final String actionsUrl) {
        return setActionsUrl(Promoter.uriFromString(actionsUrl));
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Task
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Task update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.AUTOPILOT.toString(),
            "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Task update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (actions != null) {
            request.addPostParam("Actions", Converter.mapToJson(actions));
        }

        if (actionsUrl != null) {
            request.addPostParam("ActionsUrl", actionsUrl.toString());
        }
    }
}