/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.autopilot.v1.assistant.task;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class SampleCreator extends Creator<Sample> {
    private final String pathAssistantSid;
    private final String pathTaskSid;
    private final String language;
    private final String taggedText;
    private String sourceChannel;

    /**
     * Construct a new SampleCreator.
     *
     * @param pathAssistantSid The SID of the Assistant that is the parent of the
     *                         Task associated with the new resource
     * @param pathTaskSid The SID of the Task associated with the Sample resource
     *                    to create
     * @param language The ISO language-country string that specifies the language
     *                 used for the new sample
     * @param taggedText The text example of how end users might express the task
     */
    public SampleCreator(final String pathAssistantSid,
                         final String pathTaskSid,
                         final String language,
                         final String taggedText) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
        this.language = language;
        this.taggedText = taggedText;
    }

    /**
     * The communication channel from which the new sample was captured. Can be:
     * `voice`, `sms`, `chat`, `alexa`, `google-assistant`, `slack`, or null if not
     * included..
     *
     * @param sourceChannel The communication channel from which the new sample was
     *                      captured
     * @return this
     */
    public SampleCreator setSourceChannel(final String sourceChannel) {
        this.sourceChannel = sourceChannel;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Sample
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Sample create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.AUTOPILOT.toString(),
            "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Samples"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Sample creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Sample.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (language != null) {
            request.addPostParam("Language", language);
        }

        if (taggedText != null) {
            request.addPostParam("TaggedText", taggedText);
        }

        if (sourceChannel != null) {
            request.addPostParam("SourceChannel", sourceChannel);
        }
    }
}