/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class AddressConfiguration extends Resource {
    private static final long serialVersionUID = 249555236232104L;

    public enum Type {
        SMS("sms"),
        WHATSAPP("whatsapp"),
        MESSENGER("messenger"),
        GBM("gbm");

        private final String value;

        private Type(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Type from a string.
         * @param value string value
         * @return generated Type
         */
        @JsonCreator
        public static Type forValue(final String value) {
            return Promoter.enumFromString(value, Type.values());
        }
    }

    public enum AutoCreationType {
        WEBHOOK("webhook"),
        STUDIO("studio"),
        DEFAULT("default");

        private final String value;

        private AutoCreationType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a AutoCreationType from a string.
         * @param value string value
         * @return generated AutoCreationType
         */
        @JsonCreator
        public static AutoCreationType forValue(final String value) {
            return Promoter.enumFromString(value, AutoCreationType.values());
        }
    }

    public enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Method from a string.
         * @param value string value
         * @return generated Method
         */
        @JsonCreator
        public static Method forValue(final String value) {
            return Promoter.enumFromString(value, Method.values());
        }
    }

    /**
     * Create a AddressConfigurationReader to execute read.
     *
     * @return AddressConfigurationReader capable of executing the read
     */
    public static AddressConfigurationReader reader() {
        return new AddressConfigurationReader();
    }

    /**
     * Create a AddressConfigurationFetcher to execute fetch.
     *
     * @param pathSid The SID or Address of the Configuration.
     * @return AddressConfigurationFetcher capable of executing the fetch
     */
    public static AddressConfigurationFetcher fetcher(final String pathSid) {
        return new AddressConfigurationFetcher(pathSid);
    }

    /**
     * Create a AddressConfigurationCreator to execute create.
     *
     * @param type Type of Address.
     * @param address The unique address to be configured.
     * @return AddressConfigurationCreator capable of executing the create
     */
    public static AddressConfigurationCreator creator(final AddressConfiguration.Type type,
                                                      final String address) {
        return new AddressConfigurationCreator(type, address);
    }

    /**
     * Create a AddressConfigurationUpdater to execute update.
     *
     * @param pathSid The SID or Address of the Configuration.
     * @return AddressConfigurationUpdater capable of executing the update
     */
    public static AddressConfigurationUpdater updater(final String pathSid) {
        return new AddressConfigurationUpdater(pathSid);
    }

    /**
     * Create a AddressConfigurationDeleter to execute delete.
     *
     * @param pathSid The SID or Address of the Configuration.
     * @return AddressConfigurationDeleter capable of executing the delete
     */
    public static AddressConfigurationDeleter deleter(final String pathSid) {
        return new AddressConfigurationDeleter(pathSid);
    }

    /**
     * Converts a JSON String into a AddressConfiguration object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return AddressConfiguration object represented by the provided JSON
     */
    public static AddressConfiguration fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AddressConfiguration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a AddressConfiguration object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return AddressConfiguration object represented by the provided JSON
     */
    public static AddressConfiguration fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AddressConfiguration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String type;
    private final String address;
    private final String friendlyName;
    private final Map<String, Object> autoCreation;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private AddressConfiguration(@JsonProperty("sid")
                                 final String sid,
                                 @JsonProperty("account_sid")
                                 final String accountSid,
                                 @JsonProperty("type")
                                 final String type,
                                 @JsonProperty("address")
                                 final String address,
                                 @JsonProperty("friendly_name")
                                 final String friendlyName,
                                 @JsonProperty("auto_creation")
                                 final Map<String, Object> autoCreation,
                                 @JsonProperty("date_created")
                                 final String dateCreated,
                                 @JsonProperty("date_updated")
                                 final String dateUpdated,
                                 @JsonProperty("url")
                                 final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.type = type;
        this.address = address;
        this.friendlyName = friendlyName;
        this.autoCreation = autoCreation;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns A 34 character string that uniquely identifies this resource..
     *
     * @return A 34 character string that uniquely identifies this resource.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The unique ID of the Account the address belongs to..
     *
     * @return The unique ID of the Account the address belongs to.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns Type of Address..
     *
     * @return Type of Address.
     */
    public final String getType() {
        return this.type;
    }

    /**
     * Returns The unique address to be configured..
     *
     * @return The unique address to be configured.
     */
    public final String getAddress() {
        return this.address;
    }

    /**
     * Returns The human-readable name of this configuration..
     *
     * @return The human-readable name of this configuration.
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns Auto Creation configuration for the address..
     *
     * @return Auto Creation configuration for the address.
     */
    public final Map<String, Object> getAutoCreation() {
        return this.autoCreation;
    }

    /**
     * Returns The date that this resource was created..
     *
     * @return The date that this resource was created.
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The date that this resource was last updated..
     *
     * @return The date that this resource was last updated.
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns An absolute URL for this address configuration..
     *
     * @return An absolute URL for this address configuration.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AddressConfiguration other = (AddressConfiguration) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(type, other.type) &&
               Objects.equals(address, other.address) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(autoCreation, other.autoCreation) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            type,
                            address,
                            friendlyName,
                            autoCreation,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}