/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;

public class AddressConfigurationUpdater extends Updater<AddressConfiguration> {
    private final String pathSid;
    private String friendlyName;
    private Boolean autoCreationEnabled;
    private AddressConfiguration.AutoCreationType autoCreationType;
    private String autoCreationConversationServiceSid;
    private String autoCreationWebhookUrl;
    private AddressConfiguration.Method autoCreationWebhookMethod;
    private List<String> autoCreationWebhookFilters;
    private String autoCreationStudioFlowSid;
    private Integer autoCreationStudioRetryCount;

    /**
     * Construct a new AddressConfigurationUpdater.
     *
     * @param pathSid The SID or Address of the Configuration.
     */
    public AddressConfigurationUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * The human-readable name of this configuration, limited to 256 characters.
     * Optional..
     *
     * @param friendlyName The human-readable name of this configuration.
     * @return this
     */
    public AddressConfigurationUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * Enable/Disable auto-creating conversations for messages to this address.
     *
     * @param autoCreationEnabled Enable/Disable auto-creating conversations for
     *                            messages to this address
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationEnabled(final Boolean autoCreationEnabled) {
        this.autoCreationEnabled = autoCreationEnabled;
        return this;
    }

    /**
     * Type of Auto Creation. Value can be one of `webhook`, `studio` or `default`..
     *
     * @param autoCreationType Type of Auto Creation.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationType(final AddressConfiguration.AutoCreationType autoCreationType) {
        this.autoCreationType = autoCreationType;
        return this;
    }

    /**
     * Conversation Service for the auto-created conversation. If not set, the
     * conversation is created in the default service..
     *
     * @param autoCreationConversationServiceSid Conversation Service for the
     *                                           auto-created conversation.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationConversationServiceSid(final String autoCreationConversationServiceSid) {
        this.autoCreationConversationServiceSid = autoCreationConversationServiceSid;
        return this;
    }

    /**
     * For type `webhook`, the url for the webhook request..
     *
     * @param autoCreationWebhookUrl For type `webhook`, the url for the webhook
     *                               request.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationWebhookUrl(final String autoCreationWebhookUrl) {
        this.autoCreationWebhookUrl = autoCreationWebhookUrl;
        return this;
    }

    /**
     * For type `webhook`, the HTTP method to be used when sending a webhook
     * request..
     *
     * @param autoCreationWebhookMethod For type `webhook`, the HTTP method to be
     *                                  used when sending a webhook request.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationWebhookMethod(final AddressConfiguration.Method autoCreationWebhookMethod) {
        this.autoCreationWebhookMethod = autoCreationWebhookMethod;
        return this;
    }

    /**
     * The list of events, firing webhook event for this Conversation. Values can be
     * any of the following: `onMessageAdded`, `onMessageUpdated`,
     * `onMessageRemoved`, `onConversationUpdated`, `onConversationStateUpdated`,
     * `onConversationRemoved`, `onParticipantAdded`, `onParticipantUpdated`,
     * `onParticipantRemoved`, `onDeliveryUpdated`.
     *
     * @param autoCreationWebhookFilters The list of events, firing webhook event
     *                                   for this Conversation.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationWebhookFilters(final List<String> autoCreationWebhookFilters) {
        this.autoCreationWebhookFilters = autoCreationWebhookFilters;
        return this;
    }

    /**
     * The list of events, firing webhook event for this Conversation. Values can be
     * any of the following: `onMessageAdded`, `onMessageUpdated`,
     * `onMessageRemoved`, `onConversationUpdated`, `onConversationStateUpdated`,
     * `onConversationRemoved`, `onParticipantAdded`, `onParticipantUpdated`,
     * `onParticipantRemoved`, `onDeliveryUpdated`.
     *
     * @param autoCreationWebhookFilters The list of events, firing webhook event
     *                                   for this Conversation.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationWebhookFilters(final String autoCreationWebhookFilters) {
        return setAutoCreationWebhookFilters(Promoter.listOfOne(autoCreationWebhookFilters));
    }

    /**
     * For type `studio`, the studio flow SID where the webhook should be sent to..
     *
     * @param autoCreationStudioFlowSid For type `studio`, the studio flow SID
     *                                  where the webhook should be sent to.
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationStudioFlowSid(final String autoCreationStudioFlowSid) {
        this.autoCreationStudioFlowSid = autoCreationStudioFlowSid;
        return this;
    }

    /**
     * For type `studio`, number of times to retry the webhook request.
     *
     * @param autoCreationStudioRetryCount For type `studio`, number of times to
     *                                     retry the webhook request
     * @return this
     */
    public AddressConfigurationUpdater setAutoCreationStudioRetryCount(final Integer autoCreationStudioRetryCount) {
        this.autoCreationStudioRetryCount = autoCreationStudioRetryCount;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated AddressConfiguration
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public AddressConfiguration update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.CONVERSATIONS.toString(),
            "/v1/Configuration/Addresses/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("AddressConfiguration update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return AddressConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (autoCreationEnabled != null) {
            request.addPostParam("AutoCreation.Enabled", autoCreationEnabled.toString());
        }

        if (autoCreationType != null) {
            request.addPostParam("AutoCreation.Type", autoCreationType.toString());
        }

        if (autoCreationConversationServiceSid != null) {
            request.addPostParam("AutoCreation.ConversationServiceSid", autoCreationConversationServiceSid);
        }

        if (autoCreationWebhookUrl != null) {
            request.addPostParam("AutoCreation.WebhookUrl", autoCreationWebhookUrl);
        }

        if (autoCreationWebhookMethod != null) {
            request.addPostParam("AutoCreation.WebhookMethod", autoCreationWebhookMethod.toString());
        }

        if (autoCreationWebhookFilters != null) {
            for (String prop : autoCreationWebhookFilters) {
                request.addPostParam("AutoCreation.WebhookFilters", prop);
            }
        }

        if (autoCreationStudioFlowSid != null) {
            request.addPostParam("AutoCreation.StudioFlowSid", autoCreationStudioFlowSid);
        }

        if (autoCreationStudioRetryCount != null) {
            request.addPostParam("AutoCreation.StudioRetryCount", autoCreationStudioRetryCount.toString());
        }
    }
}