/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.service.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Webhook extends Resource {
    private static final long serialVersionUID = 171050559682130L;

    public enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Method from a string.
         * @param value string value
         * @return generated Method
         */
        @JsonCreator
        public static Method forValue(final String value) {
            return Promoter.enumFromString(value, Method.values());
        }
    }

    /**
     * Create a WebhookUpdater to execute update.
     *
     * @param pathChatServiceSid The unique ID of the [Conversation
     *                           Service](https://www.twilio.com/docs/conversations/api/service-resource)
     *                           this conversation belongs to.
     * @return WebhookUpdater capable of executing the update
     */
    public static WebhookUpdater updater(final String pathChatServiceSid) {
        return new WebhookUpdater(pathChatServiceSid);
    }

    /**
     * Create a WebhookFetcher to execute fetch.
     *
     * @param pathChatServiceSid The unique ID of the [Conversation
     *                           Service](https://www.twilio.com/docs/conversations/api/service-resource)
     *                           this conversation belongs to.
     * @return WebhookFetcher capable of executing the fetch
     */
    public static WebhookFetcher fetcher(final String pathChatServiceSid) {
        return new WebhookFetcher(pathChatServiceSid);
    }

    /**
     * Converts a JSON String into a Webhook object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Webhook object represented by the provided JSON
     */
    public static Webhook fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Webhook.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Webhook object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Webhook object represented by the provided JSON
     */
    public static Webhook fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Webhook.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String chatServiceSid;
    private final URI preWebhookUrl;
    private final URI postWebhookUrl;
    private final List<String> filters;
    private final Webhook.Method method;
    private final URI url;

    @JsonCreator
    private Webhook(@JsonProperty("account_sid")
                    final String accountSid,
                    @JsonProperty("chat_service_sid")
                    final String chatServiceSid,
                    @JsonProperty("pre_webhook_url")
                    final URI preWebhookUrl,
                    @JsonProperty("post_webhook_url")
                    final URI postWebhookUrl,
                    @JsonProperty("filters")
                    final List<String> filters,
                    @JsonProperty("method")
                    final Webhook.Method method,
                    @JsonProperty("url")
                    final URI url) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.preWebhookUrl = preWebhookUrl;
        this.postWebhookUrl = postWebhookUrl;
        this.filters = filters;
        this.method = method;
        this.url = url;
    }

    /**
     * Returns The unique ID of the Account responsible for this service..
     *
     * @return The unique ID of the Account responsible for this service.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The unique ID of the <a
     * href="https://www.twilio.com/docs/conversations/api/service-resource">Conversation
     * Service</a> this conversation belongs to..
     *
     * @return The unique ID of the <a
     *         href="https://www.twilio.com/docs/conversations/api/service-resource">Conversation
     *         Service</a> this conversation belongs to.
     */
    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    /**
     * Returns The absolute url the pre-event webhook request should be sent to..
     *
     * @return The absolute url the pre-event webhook request should be sent to.
     */
    public final URI getPreWebhookUrl() {
        return this.preWebhookUrl;
    }

    /**
     * Returns The absolute url the post-event webhook request should be sent to..
     *
     * @return The absolute url the post-event webhook request should be sent to.
     */
    public final URI getPostWebhookUrl() {
        return this.postWebhookUrl;
    }

    /**
     * Returns The list of events that your configured webhook targets will receive.
     * Events not configured here will not fire..
     *
     * @return The list of events that your configured webhook targets will
     *         receive. Events not configured here will not fire.
     */
    public final List<String> getFilters() {
        return this.filters;
    }

    /**
     * Returns The HTTP method to be used when sending a webhook request.
     *
     * @return The HTTP method to be used when sending a webhook request
     */
    public final Webhook.Method getMethod() {
        return this.method;
    }

    /**
     * Returns An absolute URL for this webhook..
     *
     * @return An absolute URL for this webhook.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Webhook other = (Webhook) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(chatServiceSid, other.chatServiceSid) &&
               Objects.equals(preWebhookUrl, other.preWebhookUrl) &&
               Objects.equals(postWebhookUrl, other.postWebhookUrl) &&
               Objects.equals(filters, other.filters) &&
               Objects.equals(method, other.method) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            chatServiceSid,
                            preWebhookUrl,
                            postWebhookUrl,
                            filters,
                            method,
                            url);
    }
}