/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.service.user;

import com.twilio.base.Updater;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.time.ZonedDateTime;

public class UserConversationUpdater extends Updater<UserConversation> {
    private final String pathChatServiceSid;
    private final String pathUserSid;
    private final String pathConversationSid;
    private UserConversation.NotificationLevel notificationLevel;
    private ZonedDateTime lastReadTimestamp;
    private Integer lastReadMessageIndex;

    /**
     * Construct a new UserConversationUpdater.
     *
     * @param pathChatServiceSid The SID of the Conversation Service that the
     *                           resource is associated with.
     * @param pathUserSid The unique SID identifier of the User.
     * @param pathConversationSid The unique SID identifier of the Conversation.
     */
    public UserConversationUpdater(final String pathChatServiceSid,
                                   final String pathUserSid,
                                   final String pathConversationSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathUserSid = pathUserSid;
        this.pathConversationSid = pathConversationSid;
    }

    /**
     * The Notification Level of this User Conversation. One of `default` or
     * `muted`..
     *
     * @param notificationLevel The Notification Level of this User Conversation.
     * @return this
     */
    public UserConversationUpdater setNotificationLevel(final UserConversation.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    /**
     * The date of the last message read in conversation by the user, given in ISO
     * 8601 format..
     *
     * @param lastReadTimestamp The date of the last message read in conversation
     *                          by the user.
     * @return this
     */
    public UserConversationUpdater setLastReadTimestamp(final ZonedDateTime lastReadTimestamp) {
        this.lastReadTimestamp = lastReadTimestamp;
        return this;
    }

    /**
     * The index of the last Message in the Conversation that the Participant has
     * read..
     *
     * @param lastReadMessageIndex The index of the last read Message.
     * @return this
     */
    public UserConversationUpdater setLastReadMessageIndex(final Integer lastReadMessageIndex) {
        this.lastReadMessageIndex = lastReadMessageIndex;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated UserConversation
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public UserConversation update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.CONVERSATIONS.toString(),
            "/v1/Services/" + this.pathChatServiceSid + "/Users/" + this.pathUserSid + "/Conversations/" + this.pathConversationSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UserConversation update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return UserConversation.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (notificationLevel != null) {
            request.addPostParam("NotificationLevel", notificationLevel.toString());
        }

        if (lastReadTimestamp != null) {
            request.addPostParam("LastReadTimestamp", lastReadTimestamp.toInstant().toString());
        }

        if (lastReadMessageIndex != null) {
            request.addPostParam("LastReadMessageIndex", lastReadMessageIndex.toString());
        }
    }
}